package com.xforceplus.casservice.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2023-12-21
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class RetailerSupplierMapping implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 零售商编码
   */
  @TableField("retailerCode")
  private String retailerCode;

  /**
   * 零售商名称
   */
  @TableField("retailerName")
  private String retailerName;

  /**
   * 门店编码
   */
  @TableField("storeCode")
  private String storeCode;

  /**
   * 门店名称
   */
  @TableField("storeName")
  private String storeName;

  /**
   * 供应商编码
   */
  @TableField("supplierCode")
  private String supplierCode;

  /**
   * 供应商名称
   */
  @TableField("supplierName")
  private String supplierName;

  /**
   * 物流模式
   */
  @TableField("shippedBy")
  private String shippedBy;

  /**
   * 大仓编码
   */
  @TableField("warehouseCode")
  private String warehouseCode;

  /**
   * 状态
   */
  private String status;

  /**
   * 审核状态
   */
  @TableField("auditStatus")
  private String auditStatus;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 大仓名称
   */
  @TableField("warehouseName")
  private String warehouseName;

  /**
   * 场景码
   */
  @TableField("sceneCode")
  private String sceneCode;


  /**
   * 对一关联关系 关联对象 salesArchives
   */
    private Long oneoneForSalesArchivesId;


  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("retailerCode", retailerCode);
      map.put("retailerName", retailerName);
      map.put("storeCode", storeCode);
      map.put("storeName", storeName);
      map.put("supplierCode", supplierCode);
      map.put("supplierName", supplierName);
      map.put("shippedBy", shippedBy);
      map.put("warehouseCode", warehouseCode);
      map.put("status", status);
      map.put("auditStatus", auditStatus);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("warehouseName", warehouseName);
      map.put("sceneCode", sceneCode);

       map.put("oneoneForSalesArchives.id", oneoneForSalesArchivesId);
      return map;
  }

  public static RetailerSupplierMapping fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    RetailerSupplierMapping entity = new RetailerSupplierMapping();
    if(map.containsKey("retailerCode")) {
      Object obj = map.get("retailerCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRetailerCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("retailerName")) {
      Object obj = map.get("retailerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRetailerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("storeCode")) {
      Object obj = map.get("storeCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStoreCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("storeName")) {
      Object obj = map.get("storeName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStoreName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("supplierCode")) {
      Object obj = map.get("supplierCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSupplierCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("supplierName")) {
      Object obj = map.get("supplierName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSupplierName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("shippedBy")) {
      Object obj = map.get("shippedBy");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setShippedBy((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("warehouseCode")) {
      Object obj = map.get("warehouseCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setWarehouseCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("auditStatus")) {
      Object obj = map.get("auditStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAuditStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("warehouseName")) {
      Object obj = map.get("warehouseName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setWarehouseName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sceneCode")) {
      Object obj = map.get("sceneCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSceneCode((String)obj);
        }
      } else{
      }
    }

    if(map.containsKey("oneoneForSalesArchives.id")) {
        Object obj = map.get("oneoneForSalesArchives.id");
      if(obj instanceof Long) {
        entity.setOneoneForSalesArchivesId((Long)obj);
      } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        entity.setOneoneForSalesArchivesId(Long.parseLong((String)obj));
      }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("retailerCode")) {
      Object obj = map.get("retailerCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRetailerCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("retailerName")) {
      Object obj = map.get("retailerName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRetailerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("storeCode")) {
      Object obj = map.get("storeCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setStoreCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("storeName")) {
      Object obj = map.get("storeName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setStoreName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("supplierCode")) {
      Object obj = map.get("supplierCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSupplierCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("supplierName")) {
      Object obj = map.get("supplierName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSupplierName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("shippedBy")) {
      Object obj = map.get("shippedBy");
      if(obj != null) {
        if(obj instanceof String) {
          this.setShippedBy((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("warehouseCode")) {
      Object obj = map.get("warehouseCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setWarehouseCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("auditStatus")) {
      Object obj = map.get("auditStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAuditStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("warehouseName")) {
      Object obj = map.get("warehouseName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setWarehouseName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sceneCode")) {
      Object obj = map.get("sceneCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSceneCode((String)obj);
        }
      } else {
      }
    }
      if(map.containsKey("oneoneForSalesArchives.id")) {
        Object obj = map.get("oneoneForSalesArchives.id");
        if(obj instanceof Long) {
          this.setOneoneForSalesArchivesId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setOneoneForSalesArchivesId(Long.parseLong((String)obj));
        }
      }
  }
}
