package com.xforceplus.casservice.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * config_item_value_type
 * </p>
 *
 * @author ultraman
 * @since 2024-01-06
 */
public enum ConfigItemValueType {

    STRING("string", "字符串"),
    NUMBER("number", "数字"),
    LIST("list", "集合");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ConfigItemValueType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ConfigItemValueType fromCode(String code){
        switch(code) {
            case "string":
                return STRING;
            case "number":
                return NUMBER;
            case "list":
                return LIST;
            default:
                return null;
        }
    }
}
