package com.xforceplus.casservice.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * strore_info
 * </p>
 *
 * @author ultraman
 * @since 2024-01-06
 */
public enum StroreInfo {

    RTMART("rtmart", "rtmart(大润发)");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    StroreInfo(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static StroreInfo fromCode(String code){
        switch(code) {
            case "rtmart":
                return RTMART;
            default:
                return null;
        }
    }
}
