package com.xforceplus.casservice.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.casservice.entity.SalesOrgnizationAffiliateInfo;
import com.xforceplus.casservice.service.ISalesOrgnizationAffiliateInfoService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-03-01
 */
@RestController
public class SalesOrgnizationAffiliateInfoController {

  @Autowired
  private ISalesOrgnizationAffiliateInfoService salesOrgnizationAffiliateInfoServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param salesOrgnizationAffiliateInfo ${table.comment}
   * @return
   */
  @GetMapping("/salesorgnizationaffiliateinfos" )
  public XfR getSalesOrgnizationAffiliateInfos(XfPage page, SalesOrgnizationAffiliateInfo salesOrgnizationAffiliateInfo) {
    return XfR.ok(salesOrgnizationAffiliateInfoServiceImpl.page(page, Wrappers.query(salesOrgnizationAffiliateInfo)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/salesorgnizationaffiliateinfos/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(salesOrgnizationAffiliateInfoServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param salesOrgnizationAffiliateInfo ${table.comment}
   * @return XfR
   */
  @PostMapping("/salesorgnizationaffiliateinfos")
  public XfR save(@RequestBody SalesOrgnizationAffiliateInfo salesOrgnizationAffiliateInfo) {
     return XfR.ok(salesOrgnizationAffiliateInfoServiceImpl.save(salesOrgnizationAffiliateInfo));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param salesOrgnizationAffiliateInfo ${table.comment}
   * @return XfR
   */
  @PutMapping("/salesorgnizationaffiliateinfos/{id}")
  public XfR putUpdate(@RequestBody SalesOrgnizationAffiliateInfo salesOrgnizationAffiliateInfo,@PathVariable Long id) {
      salesOrgnizationAffiliateInfo.setId(id);
      return XfR.ok(salesOrgnizationAffiliateInfoServiceImpl.updateById(salesOrgnizationAffiliateInfo));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param salesOrgnizationAffiliateInfo ${table.comment}
   * @return XfR
   */
  @PatchMapping("/salesorgnizationaffiliateinfos/{id}")
  public XfR patchUpdate(@RequestBody SalesOrgnizationAffiliateInfo salesOrgnizationAffiliateInfo,@PathVariable Long id) {
      SalesOrgnizationAffiliateInfo upsalesOrgnizationAffiliateInfo = salesOrgnizationAffiliateInfoServiceImpl.getById(id);
      if(upsalesOrgnizationAffiliateInfo != null){
        upsalesOrgnizationAffiliateInfo = ObjectCopyUtils.copyProperties(salesOrgnizationAffiliateInfo,upsalesOrgnizationAffiliateInfo,true);
      }
      return XfR.ok(salesOrgnizationAffiliateInfoServiceImpl.updateById(upsalesOrgnizationAffiliateInfo));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/salesorgnizationaffiliateinfos/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(salesOrgnizationAffiliateInfoServiceImpl.removeById(id));
  }

  @PostMapping("/salesorgnizationaffiliateinfos/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "sales_orgnization_affiliate_info");
     params.put("request", condition);

     return XfR.ok(salesOrgnizationAffiliateInfoServiceImpl.querys(params));
  }

}
