package com.xforceplus.casservice.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.casservice.entity.ChangeHistory;
import com.xforceplus.casservice.service.IChangeHistoryService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-04-19
 */
@RestController
public class ChangeHistoryController {

  @Autowired
  private IChangeHistoryService changeHistoryServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param changeHistory ${table.comment}
   * @return
   */
  @GetMapping("/changehistorys" )
  public XfR getChangeHistorys(XfPage page, ChangeHistory changeHistory) {
    return XfR.ok(changeHistoryServiceImpl.page(page, Wrappers.query(changeHistory)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/changehistorys/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(changeHistoryServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param changeHistory ${table.comment}
   * @return XfR
   */
  @PostMapping("/changehistorys")
  public XfR save(@RequestBody ChangeHistory changeHistory) {
     return XfR.ok(changeHistoryServiceImpl.save(changeHistory));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param changeHistory ${table.comment}
   * @return XfR
   */
  @PutMapping("/changehistorys/{id}")
  public XfR putUpdate(@RequestBody ChangeHistory changeHistory,@PathVariable Long id) {
      changeHistory.setId(id);
      return XfR.ok(changeHistoryServiceImpl.updateById(changeHistory));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param changeHistory ${table.comment}
   * @return XfR
   */
  @PatchMapping("/changehistorys/{id}")
  public XfR patchUpdate(@RequestBody ChangeHistory changeHistory,@PathVariable Long id) {
      ChangeHistory upchangeHistory = changeHistoryServiceImpl.getById(id);
      if(upchangeHistory != null){
        upchangeHistory = ObjectCopyUtils.copyProperties(changeHistory,upchangeHistory,true);
      }
      return XfR.ok(changeHistoryServiceImpl.updateById(upchangeHistory));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/changehistorys/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(changeHistoryServiceImpl.removeById(id));
  }

  @PostMapping("/changehistorys/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "change_history");
     params.put("request", condition);

     return XfR.ok(changeHistoryServiceImpl.querys(params));
  }

}
