package com.xforceplus.casservice.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.casservice.entity.RetailerConfig;
import com.xforceplus.casservice.service.IRetailerConfigService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-08-07
 */
@RestController
public class RetailerConfigController {

  @Autowired
  private IRetailerConfigService retailerConfigServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param retailerConfig ${table.comment}
   * @return
   */
  @GetMapping("/retailerconfigs" )
  public XfR getRetailerConfigs(XfPage page, RetailerConfig retailerConfig) {
    return XfR.ok(retailerConfigServiceImpl.page(page, Wrappers.query(retailerConfig)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/retailerconfigs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(retailerConfigServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param retailerConfig ${table.comment}
   * @return XfR
   */
  @PostMapping("/retailerconfigs")
  public XfR save(@RequestBody RetailerConfig retailerConfig) {
     return XfR.ok(retailerConfigServiceImpl.save(retailerConfig));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param retailerConfig ${table.comment}
   * @return XfR
   */
  @PutMapping("/retailerconfigs/{id}")
  public XfR putUpdate(@RequestBody RetailerConfig retailerConfig,@PathVariable Long id) {
      retailerConfig.setId(id);
      return XfR.ok(retailerConfigServiceImpl.updateById(retailerConfig));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param retailerConfig ${table.comment}
   * @return XfR
   */
  @PatchMapping("/retailerconfigs/{id}")
  public XfR patchUpdate(@RequestBody RetailerConfig retailerConfig,@PathVariable Long id) {
      RetailerConfig upretailerConfig = retailerConfigServiceImpl.getById(id);
      if(upretailerConfig != null){
        upretailerConfig = ObjectCopyUtils.copyProperties(retailerConfig,upretailerConfig,true);
      }
      return XfR.ok(retailerConfigServiceImpl.updateById(upretailerConfig));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/retailerconfigs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(retailerConfigServiceImpl.removeById(id));
  }

  @PostMapping("/retailerconfigs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "retailer_config");
     params.put("request", condition);

     return XfR.ok(retailerConfigServiceImpl.querys(params));
  }

}
