package com.xforceplus.casservice.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.casservice.entity.CacheInfo;
import com.xforceplus.casservice.service.ICacheInfoService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-08-09
 */
@RestController
public class CacheInfoController {

  @Autowired
  private ICacheInfoService cacheInfoServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param cacheInfo ${table.comment}
   * @return
   */
  @GetMapping("/cacheinfos" )
  public XfR getCacheInfos(XfPage page, CacheInfo cacheInfo) {
    return XfR.ok(cacheInfoServiceImpl.page(page, Wrappers.query(cacheInfo)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/cacheinfos/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(cacheInfoServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param cacheInfo ${table.comment}
   * @return XfR
   */
  @PostMapping("/cacheinfos")
  public XfR save(@RequestBody CacheInfo cacheInfo) {
     return XfR.ok(cacheInfoServiceImpl.save(cacheInfo));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param cacheInfo ${table.comment}
   * @return XfR
   */
  @PutMapping("/cacheinfos/{id}")
  public XfR putUpdate(@RequestBody CacheInfo cacheInfo,@PathVariable Long id) {
      cacheInfo.setId(id);
      return XfR.ok(cacheInfoServiceImpl.updateById(cacheInfo));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param cacheInfo ${table.comment}
   * @return XfR
   */
  @PatchMapping("/cacheinfos/{id}")
  public XfR patchUpdate(@RequestBody CacheInfo cacheInfo,@PathVariable Long id) {
      CacheInfo upcacheInfo = cacheInfoServiceImpl.getById(id);
      if(upcacheInfo != null){
        upcacheInfo = ObjectCopyUtils.copyProperties(cacheInfo,upcacheInfo,true);
      }
      return XfR.ok(cacheInfoServiceImpl.updateById(upcacheInfo));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/cacheinfos/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(cacheInfoServiceImpl.removeById(id));
  }

  @PostMapping("/cacheinfos/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "cache_info");
     params.put("request", condition);

     return XfR.ok(cacheInfoServiceImpl.querys(params));
  }

}
