package com.xforceplus.casservice.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.casservice.entity.SalesArchivesChangedHistory;
import com.xforceplus.casservice.service.ISalesArchivesChangedHistoryService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-08-09
 */
@RestController
public class SalesArchivesChangedHistoryController {

  @Autowired
  private ISalesArchivesChangedHistoryService salesArchivesChangedHistoryServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param salesArchivesChangedHistory ${table.comment}
   * @return
   */
  @GetMapping("/salesarchiveschangedhistorys" )
  public XfR getSalesArchivesChangedHistorys(XfPage page, SalesArchivesChangedHistory salesArchivesChangedHistory) {
    return XfR.ok(salesArchivesChangedHistoryServiceImpl.page(page, Wrappers.query(salesArchivesChangedHistory)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/salesarchiveschangedhistorys/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(salesArchivesChangedHistoryServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param salesArchivesChangedHistory ${table.comment}
   * @return XfR
   */
  @PostMapping("/salesarchiveschangedhistorys")
  public XfR save(@RequestBody SalesArchivesChangedHistory salesArchivesChangedHistory) {
     return XfR.ok(salesArchivesChangedHistoryServiceImpl.save(salesArchivesChangedHistory));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param salesArchivesChangedHistory ${table.comment}
   * @return XfR
   */
  @PutMapping("/salesarchiveschangedhistorys/{id}")
  public XfR putUpdate(@RequestBody SalesArchivesChangedHistory salesArchivesChangedHistory,@PathVariable Long id) {
      salesArchivesChangedHistory.setId(id);
      return XfR.ok(salesArchivesChangedHistoryServiceImpl.updateById(salesArchivesChangedHistory));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param salesArchivesChangedHistory ${table.comment}
   * @return XfR
   */
  @PatchMapping("/salesarchiveschangedhistorys/{id}")
  public XfR patchUpdate(@RequestBody SalesArchivesChangedHistory salesArchivesChangedHistory,@PathVariable Long id) {
      SalesArchivesChangedHistory upsalesArchivesChangedHistory = salesArchivesChangedHistoryServiceImpl.getById(id);
      if(upsalesArchivesChangedHistory != null){
        upsalesArchivesChangedHistory = ObjectCopyUtils.copyProperties(salesArchivesChangedHistory,upsalesArchivesChangedHistory,true);
      }
      return XfR.ok(salesArchivesChangedHistoryServiceImpl.updateById(upsalesArchivesChangedHistory));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/salesarchiveschangedhistorys/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(salesArchivesChangedHistoryServiceImpl.removeById(id));
  }

  @PostMapping("/salesarchiveschangedhistorys/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "sales_archives_changed_history");
     params.put("request", condition);

     return XfR.ok(salesArchivesChangedHistoryServiceImpl.querys(params));
  }

}
