package com.xforceplus.casservice.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.casservice.entity.StatisticApiInfo;
import com.xforceplus.casservice.service.IStatisticApiInfoService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-08-09
 */
@RestController
public class StatisticApiInfoController {

  @Autowired
  private IStatisticApiInfoService statisticApiInfoServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param statisticApiInfo ${table.comment}
   * @return
   */
  @GetMapping("/statisticapiinfos" )
  public XfR getStatisticApiInfos(XfPage page, StatisticApiInfo statisticApiInfo) {
    return XfR.ok(statisticApiInfoServiceImpl.page(page, Wrappers.query(statisticApiInfo)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/statisticapiinfos/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(statisticApiInfoServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param statisticApiInfo ${table.comment}
   * @return XfR
   */
  @PostMapping("/statisticapiinfos")
  public XfR save(@RequestBody StatisticApiInfo statisticApiInfo) {
     return XfR.ok(statisticApiInfoServiceImpl.save(statisticApiInfo));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param statisticApiInfo ${table.comment}
   * @return XfR
   */
  @PutMapping("/statisticapiinfos/{id}")
  public XfR putUpdate(@RequestBody StatisticApiInfo statisticApiInfo,@PathVariable Long id) {
      statisticApiInfo.setId(id);
      return XfR.ok(statisticApiInfoServiceImpl.updateById(statisticApiInfo));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param statisticApiInfo ${table.comment}
   * @return XfR
   */
  @PatchMapping("/statisticapiinfos/{id}")
  public XfR patchUpdate(@RequestBody StatisticApiInfo statisticApiInfo,@PathVariable Long id) {
      StatisticApiInfo upstatisticApiInfo = statisticApiInfoServiceImpl.getById(id);
      if(upstatisticApiInfo != null){
        upstatisticApiInfo = ObjectCopyUtils.copyProperties(statisticApiInfo,upstatisticApiInfo,true);
      }
      return XfR.ok(statisticApiInfoServiceImpl.updateById(upstatisticApiInfo));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/statisticapiinfos/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(statisticApiInfoServiceImpl.removeById(id));
  }

  @PostMapping("/statisticapiinfos/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "statistic_api_info");
     params.put("request", condition);

     return XfR.ok(statisticApiInfoServiceImpl.querys(params));
  }

}
