/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.cc.tooling;

import com.xforceplus.cc.tooling.ResourceLocker;
import com.xforceplus.cc.tooling.utils.Locker;
import com.xforceplus.cc.tooling.utils.LockerSupport;
import com.xforceplus.cc.tooling.utils.StateKeys;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;

public abstract class AbstractResourceLocker
implements ResourceLocker {
    private static final long RETRY_DELAY = 200L;
    private long retryDelay = 0L;

    public long getRetryDelay() {
        return this.retryDelay <= 0L ? 200L : this.retryDelay;
    }

    public void setRetryDelay(long retryDelay) {
        this.retryDelay = retryDelay;
    }

    @Override
    public boolean isLocking(String resource) {
        String key = LockerSupport.buildLockKey(resource);
        return this.doIsLocking(key);
    }

    @Override
    public void lock(String resource) throws InterruptedException {
        this.doTryLocks(Long.MAX_VALUE, resource);
    }

    @Override
    public void locks(String ... resources) throws InterruptedException {
        this.doTryLocks(Long.MAX_VALUE, resources);
    }

    @Override
    public boolean tryLock(String resource) {
        boolean result = false;
        try {
            result = this.doTryLocks(-1L, resource);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return result;
    }

    @Override
    public boolean tryLock(long waitTimeoutMs, String resoruce) throws InterruptedException {
        return this.doTryLocks(waitTimeoutMs, resoruce);
    }

    @Override
    public boolean tryLocks(String ... resources) {
        boolean result = false;
        try {
            result = this.doTryLocks(-1L, resources);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return result;
    }

    @Override
    public boolean tryLocks(long waitTimeoutMs, String ... resources) throws InterruptedException {
        return this.doTryLocks(waitTimeoutMs, resources);
    }

    @Override
    public boolean unlock(String resource) {
        return this.unlocks(resource).length == 0;
    }

    @Override
    public String[] unlocks(String ... resources) {
        if (this.autoUnlocks()) {
            return new String[0];
        }
        StateKeys stateKeys = this.buildKeys(resources);
        Locker locker = LockerSupport.getLocker();
        this.doUnLocks(locker, stateKeys);
        return (String[])Arrays.stream(stateKeys.getNoCompleteKeys()).map(k -> LockerSupport.parseResourceFormLockKey(k)).toArray(String[]::new);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doTryLocks(long waitTimeoutMs, String ... resources) throws InterruptedException {
        StateKeys keys = this.buildKeys(resources);
        Locker locker = LockerSupport.getLocker();
        long delay = this.getRetryDelay();
        try {
            long timePass = 0L;
            while (true) {
                this.doLocks(locker, keys);
                if (keys.isCompleteness()) {
                    locker.incrSuccess(keys.size());
                    boolean bl = true;
                    return bl;
                }
                if (waitTimeoutMs <= 0L) {
                    boolean bl = false;
                    return bl;
                }
                if (keys.isCompleteness()) continue;
                this.await(delay);
                if ((timePass += delay) >= waitTimeoutMs) break;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (!keys.isCompleteness()) {
                this.doUnLocks(locker, new StateKeys(keys.getCompleteKeys()));
                LockerSupport.cleanLockerIfCan();
            }
        }
    }

    private StateKeys buildKeys(String ... resources) {
        return new StateKeys((String[])Arrays.stream(resources).distinct().sorted().map(r -> LockerSupport.buildLockKey(r)).toArray(String[]::new));
    }

    private void await(long time) throws InterruptedException {
        TimeUnit.MILLISECONDS.sleep(time);
    }

    protected abstract void doLocks(Locker var1, StateKeys var2);

    protected abstract void doUnLocks(Locker var1, StateKeys var2);

    protected abstract boolean doIsLocking(String var1);

    protected boolean autoUnlocks() {
        return false;
    }
}

