/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.cc.tooling;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.json.JsonReadFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.xforceplus.cc.tooling.AbstractResourceLocker;
import com.xforceplus.cc.tooling.utils.ExecutorHelper;
import com.xforceplus.cc.tooling.utils.Locker;
import com.xforceplus.cc.tooling.utils.StateKeys;
import com.xforceplus.cc.tooling.utils.timerwheel.TimeoutNotification;
import com.xforceplus.cc.tooling.utils.timerwheel.TimerWheel;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.zip.CRC32;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MysqlResourceLocker
extends AbstractResourceLocker {
    public static final ObjectMapper OBJECT_MAPPER = JsonMapper.builder().enable(new JsonReadFeature[]{JsonReadFeature.ALLOW_BACKSLASH_ESCAPING_ANY_CHARACTER}).enable(new JsonReadFeature[]{JsonReadFeature.ALLOW_TRAILING_COMMA}).enable(new JsonReadFeature[]{JsonReadFeature.ALLOW_JAVA_COMMENTS}).enable(new JsonReadFeature[]{JsonReadFeature.ALLOW_BACKSLASH_ESCAPING_ANY_CHARACTER}).enable(new JsonReadFeature[]{JsonReadFeature.ALLOW_MISSING_VALUES}).enable(new JsonReadFeature[]{JsonReadFeature.ALLOW_SINGLE_QUOTES}).enable(new JsonReadFeature[]{JsonReadFeature.ALLOW_LEADING_ZEROS_FOR_NUMBERS}).enable(new JsonReadFeature[]{JsonReadFeature.ALLOW_NON_NUMERIC_NUMBERS}).enable(new JsonReadFeature[]{JsonReadFeature.ALLOW_UNESCAPED_CONTROL_CHARS}).enable(new JsonReadFeature[]{JsonReadFeature.ALLOW_UNQUOTED_FIELD_NAMES}).enable(new JsonReadFeature[]{JsonReadFeature.ALLOW_YAML_COMMENTS}).build();
    private static final int SUCCESS = 1;
    private static final Logger LOGGER = LoggerFactory.getLogger(MysqlResourceLocker.class);
    private static final String KEY_PREFIX = "k";
    private static final String TIME_KEY_PREFIX = "t_";
    private static final String TRY_LOCK_SQL = "UPDATE %s set barrel = JSON_INSERT(barrel, '$.\"%s\"', '%s', '$.\"%s\"', %d) WHERE id = %d AND JSON_CONTAINS_PATH(barrel, 'all', '$.\"%s\"') = 0";
    private static final String UN_LOCK_SQL = "UPDATE %s set barrel = JSON_REMOVE(barrel, '$.\"%s\"', '$.\"%s\"') WHERE id = %d AND barrel->>'$.\"%s\"' = '%s'";
    private static final String IS_LOCK_SQL = "SELECT count(*) FROM %s WHERE id = %d AND JSON_CONTAINS_PATH(barrel, 'all', '$.\"%s\"') = 1";
    private static final String RENEWAL_SQL = "UPDATE %s set barrel = JSON_SET(barrel, '$.\"%s\"', %d) WHERE id = %d AND barrel->>'$.\"%s\"' = '%s'";
    private static final String CLEAN_SQL = "UPDATE %s set barrel = JSON_REMOVE(barrel, '$.\"%s\"', '$.\"%s\"') WHERE id = %d";
    private static final String DEFAULT_TABLE_NAME = "locks";
    private static final long DEFAULT_SLOT_SIZE = 10L;
    private long renewalTimeMs;
    private long timeoutMs;
    private long cleanCheckIntervalMs;
    private Map<String, RenewalPackage> keyLogTable;
    private TimerWheel<RenewalPackage> renewalTimerWheel;
    private ScheduledExecutorService cleanWorker;
    private int tryLockProcessTimeoutSecond = 1;
    private String tableName;
    private DataSource ds;
    private long slotSize;
    private boolean renewal = true;
    private boolean closed = false;

    private MysqlResourceLocker() {
    }

    public void init() throws Exception {
        long size;
        super.setRetryDelay(500L);
        if (this.slotSize <= 10L) {
            this.slotSize = 10L;
        }
        if (this.slotSize > (size = this.readMysqlSlotSize())) {
            throw new RuntimeException(String.format("The %s slot is set up, but there are only %s slots.", this.slotSize, size));
        }
        this.keyLogTable = new ConcurrentHashMap<String, RenewalPackage>();
        if (this.renewal) {
            this.renewalTimerWheel = new TimerWheel<RenewalPackage>(new RenewalTimeoutNotification(this.ds));
        }
        this.cleanWorker = Executors.newScheduledThreadPool(1, ExecutorHelper.buildNameThreadFactory("mysql-lock-cleaner"));
        this.cleanWorker.scheduleWithFixedDelay(new Cleaner(this.ds, this.tableName), this.cleanCheckIntervalMs, this.cleanCheckIntervalMs, TimeUnit.MILLISECONDS);
        this.closed = false;
    }

    public void destroy() throws Exception {
        this.closed = true;
        if (this.renewal) {
            this.renewalTimerWheel.destroy();
        }
        ExecutorHelper.shutdownAndAwaitTermination(this.cleanWorker);
        LOGGER.info("Start cleaning existing locks.");
        for (RenewalPackage renewalPackage : this.keyLogTable.values()) {
            String key = renewalPackage.getKey();
            String locker = renewalPackage.getLocker();
            StateKeys stateKeys = new StateKeys(key);
            this.doMysqlUnLock(locker, stateKeys);
        }
    }

    public long getSlotSize() {
        return this.slotSize;
    }

    @Override
    protected void doLocks(Locker locker, StateKeys stateKeys) {
        if (this.closed) {
            throw new IllegalStateException("Mysql locker is closed!");
        }
        try {
            this.doMysqlLock(locker.getName(), stateKeys);
        }
        catch (SQLException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    protected void doUnLocks(Locker locker, StateKeys stateKeys) {
        if (this.closed) {
            throw new IllegalStateException("Mysql locker is closed!");
        }
        try {
            this.doMysqlUnLock(locker.getName(), stateKeys);
        }
        catch (SQLException ex) {
            LOGGER.error(ex.getMessage(), (Throwable)ex);
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    @Override
    protected boolean doIsLocking(String key) {
        try {
            return this.doMysqlIsLock(key);
        }
        catch (SQLException ex) {
            LOGGER.error(ex.getMessage(), (Throwable)ex);
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    @Override
    protected boolean autoUnlocks() {
        return false;
    }

    /*
     * Exception decompiling
     */
    private long readMysqlSlotSize() throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private boolean doMysqlIsLock(String key) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doMysqlUnLock(String locker, StateKeys stateKeys) throws SQLException {
        Connection conn = this.getConnection();
        boolean autoCommit = conn.getAutoCommit();
        conn.setAutoCommit(false);
        try {
            String[] keys = stateKeys.getNoCompleteKeys();
            HashMap<String, String> noLockKeys = new HashMap<String, String>();
            try (Statement ps = conn.createStatement();){
                ps.setQueryTimeout(this.tryLockProcessTimeoutSecond);
                for (String key : keys) {
                    if (!this.keyLogTable.containsKey(key)) {
                        noLockKeys.put(key, "");
                    }
                    long slot = this.calculateSlot(key);
                    String sql = this.buildUnLockSql(locker, key, slot);
                    ps.addBatch(sql);
                    if (!this.renewal) continue;
                    RenewalPackage renewalPackage = new RenewalPackage(locker, this.calculateSlot(key), key);
                    this.renewalTimerWheel.remove(renewalPackage);
                }
                int[] results = ps.executeBatch();
                for (int i = 0; i < keys.length; ++i) {
                    String key = keys[i];
                    if (noLockKeys.containsKey(key)) {
                        stateKeys.completed(key);
                        continue;
                    }
                    if (results[i] != 1) continue;
                    stateKeys.completed(key);
                    this.keyLogTable.remove(key);
                }
            }
            catch (Exception ex) {
                throw new SQLException(ex.getMessage(), ex);
            }
            conn.commit();
        }
        finally {
            conn.setAutoCommit(autoCommit);
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doMysqlLock(String locker, StateKeys stateKeys) throws SQLException {
        Connection conn = this.getConnection();
        boolean autoCommit = conn.getAutoCommit();
        conn.setAutoCommit(false);
        String[] keys = stateKeys.getNoCompleteKeys();
        try {
            int[] results;
            try (Statement ps = conn.createStatement();){
                ps.setQueryTimeout(this.tryLockProcessTimeoutSecond);
                for (String key : keys) {
                    long slot = this.calculateSlot(key);
                    String sql = this.buildLockSql(locker, key, slot);
                    ps.addBatch(sql);
                }
                results = ps.executeBatch();
            }
            catch (Exception ex) {
                throw new SQLException(ex.getMessage(), ex);
            }
            if (results != null) {
                long successSize = Arrays.stream(results).filter(r -> r == 1).count();
                if (successSize == (long)keys.length) {
                    for (String key : keys) {
                        stateKeys.completed(key);
                        RenewalPackage renewalPackage = new RenewalPackage(locker, this.calculateSlot(key), key);
                        if (this.renewal) {
                            this.renewalTimerWheel.add(renewalPackage, this.renewalTimeMs);
                        }
                        this.keyLogTable.put(key, renewalPackage);
                    }
                    conn.commit();
                } else {
                    conn.rollback();
                }
            } else {
                conn.rollback();
            }
        }
        finally {
            conn.setAutoCommit(autoCommit);
            conn.close();
        }
    }

    private String buildIsLockSql(String key, long slot) {
        return String.format(IS_LOCK_SQL, this.tableName, slot, this.wrapperKey(key));
    }

    private String buildLockSql(String locker, String key, long slot) {
        String lockKey = this.wrapperKey(key);
        String lockTimeKey = this.wrapperTimeKey(key);
        long time = System.currentTimeMillis();
        return String.format(TRY_LOCK_SQL, this.tableName, lockKey, locker, lockTimeKey, time, slot, lockKey);
    }

    private String buildUnLockSql(String locker, String key, long slot) {
        String lockKey = this.wrapperKey(key);
        String lockTimeKey = this.wrapperTimeKey(key);
        return String.format(UN_LOCK_SQL, this.tableName, lockKey, lockTimeKey, slot, lockKey, locker);
    }

    private String buildRenewalSql(String locker, String key, long slot) {
        String lockKey = this.wrapperKey(key);
        String lockTimeKey = this.wrapperTimeKey(key);
        long time = System.currentTimeMillis();
        return String.format(RENEWAL_SQL, this.tableName, lockTimeKey, time, slot, lockKey, locker);
    }

    private String buildCleanSql(String key, long slot) {
        String lockKey = this.wrapperKey(key);
        String lockTimeKey = this.wrapperTimeKey(key);
        return String.format(CLEAN_SQL, this.tableName, lockKey, lockTimeKey, slot);
    }

    private String wrapperKey(String key) {
        return KEY_PREFIX + key;
    }

    private String wrapperTimeKey(String key) {
        return TIME_KEY_PREFIX + key;
    }

    private Connection getConnection() throws SQLException {
        Connection conn = this.ds.getConnection();
        if (conn.getAutoCommit()) {
            conn.setAutoCommit(false);
        }
        return conn;
    }

    private boolean isTimeout(long time) {
        return System.currentTimeMillis() - time >= this.timeoutMs;
    }

    private String parseKeyFromTimeKey(String timeKey) {
        if (timeKey.startsWith(TIME_KEY_PREFIX)) {
            int len = TIME_KEY_PREFIX.length();
            return timeKey.substring(len);
        }
        throw new IllegalArgumentException(String.format("Wrong time key.[%s]", timeKey));
    }

    protected long calculateSlot(String key) {
        CRC32 crc32 = new CRC32();
        byte[] bytes = key.getBytes(StandardCharsets.UTF_8);
        crc32.update(bytes);
        long value = crc32.getValue();
        long slot = value % this.slotSize;
        if (slot == 0L) {
            return slot + 1L;
        }
        return slot;
    }

    private class Cleaner
    implements Runnable {
        private final String sql;
        private final DataSource ds;

        public Cleaner(DataSource ds, String tableName) {
            this.ds = ds;
            this.sql = String.format("SELECT id, barrel FROM %s", tableName);
        }

        @Override
        public void run() {
            LOGGER.info("Start clean...");
            try {
                List<CleanPackage> cleanPackages = this.findNeedClean();
                this.clean(cleanPackages);
            }
            catch (Exception ex) {
                LOGGER.error(ex.getMessage(), (Throwable)ex);
            }
            LOGGER.info("Clean finished.");
        }

        private List<CleanPackage> findNeedClean() throws Exception {
            ArrayList<CleanPackage> needCleanKeys = new ArrayList<CleanPackage>();
            try (Connection conn = this.ds.getConnection();){
                try (Statement st = conn.createStatement(1003, 1007);){
                    st.setFetchSize(Integer.MIN_VALUE);
                    try (ResultSet rs = st.executeQuery(this.sql);){
                        while (rs.next()) {
                            Map values;
                            long id = rs.getLong("id");
                            String json = rs.getString("barrel");
                            try {
                                values = (Map)OBJECT_MAPPER.readValue(json, Map.class);
                            }
                            catch (JsonProcessingException e) {
                                e.printStackTrace(System.err);
                                continue;
                            }
                            for (Map.Entry entry : values.entrySet()) {
                                long timeMs;
                                String key = (String)entry.getKey();
                                if (!key.startsWith(MysqlResourceLocker.TIME_KEY_PREFIX) || !MysqlResourceLocker.this.isTimeout(timeMs = ((Long)entry.getValue()).longValue())) continue;
                                String orginalKey = MysqlResourceLocker.this.parseKeyFromTimeKey(key);
                                needCleanKeys.add(new CleanPackage(id, orginalKey));
                            }
                        }
                    }
                }
                this.clean(needCleanKeys);
            }
            return needCleanKeys;
        }

        private void clean(List<CleanPackage> cleanPackages) throws SQLException {
            try (Connection conn = this.ds.getConnection();
                 Statement st = conn.createStatement();){
                for (CleanPackage c : cleanPackages) {
                    String sql = MysqlResourceLocker.this.buildCleanSql(c.key, c.slot);
                    st.addBatch(sql);
                }
                st.executeBatch();
            }
        }
    }

    private static class CleanPackage {
        private final long slot;
        private final String key;

        public CleanPackage(long slot, String key) {
            this.slot = slot;
            this.key = key;
        }

        public long getSlot() {
            return this.slot;
        }

        public String getKey() {
            return this.key;
        }
    }

    private class RenewalTimeoutNotification
    implements TimeoutNotification<RenewalPackage> {
        private final DataSource ds;

        public RenewalTimeoutNotification(DataSource ds) {
            this.ds = ds;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long notice(RenewalPackage renewalPackage) {
            LOGGER.debug("Lock({}) start renewal....", (Object)renewalPackage);
            Connection conn = null;
            try {
                conn = MysqlResourceLocker.this.getConnection();
                String locker = renewalPackage.getLocker();
                String key = renewalPackage.getKey();
                long slot = renewalPackage.getSlot();
                String sql = MysqlResourceLocker.this.buildRenewalSql(locker, key, slot);
                try (Statement statement = conn.createStatement();){
                    statement.executeUpdate(sql);
                }
                conn.commit();
                long l = MysqlResourceLocker.this.renewalTimeMs;
                return l;
            }
            catch (Exception ex) {
                LOGGER.error(String.format("The lock(%s) renewal failed because of %s.", renewalPackage, ex.getMessage()), (Throwable)ex);
            }
            finally {
                LOGGER.debug("Lock({}) start renewal....SUCCESS.", (Object)renewalPackage);
                try {
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                }
            }
            return 0L;
        }
    }

    public static final class Builder {
        private long cleanCheckIntervalMs = 3600000L;
        private long renewalTimeMs = 30000L;
        private long timeoutMs = 60000L;
        private int tryLockProcessTimeoutSecond = 1;
        private String tableName = "locks";
        private DataSource ds;
        private long slotSize = 10L;
        private boolean renewal = true;

        private Builder() {
        }

        public static Builder anMysqlResourceLocker() {
            return new Builder();
        }

        public Builder withRenewalTimeMs(long renewalTimeMs) {
            this.renewalTimeMs = renewalTimeMs;
            return this;
        }

        public Builder withTimeoutMs(long timeoutMs) {
            this.timeoutMs = timeoutMs;
            return this;
        }

        public Builder withTryLockProcessTimeoutSecond(int tryLockProcessTimeoutSecond) {
            this.tryLockProcessTimeoutSecond = tryLockProcessTimeoutSecond;
            return this;
        }

        public Builder withTableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public Builder withCleanCheckIntervalMs(long cleanCheckIntervalMs) {
            this.cleanCheckIntervalMs = cleanCheckIntervalMs;
            return this;
        }

        public Builder withDs(DataSource ds) {
            this.ds = ds;
            return this;
        }

        public Builder withSlotSize(long slotSize) {
            this.slotSize = slotSize;
            return this;
        }

        public Builder withRenewal(boolean renewal) {
            this.renewal = renewal;
            return this;
        }

        public MysqlResourceLocker build() throws Exception {
            MysqlResourceLocker mysqlResourceLocker = new MysqlResourceLocker();
            mysqlResourceLocker.tableName = this.tableName;
            mysqlResourceLocker.ds = this.ds;
            mysqlResourceLocker.slotSize = this.slotSize;
            mysqlResourceLocker.renewal = this.renewal;
            mysqlResourceLocker.tryLockProcessTimeoutSecond = this.tryLockProcessTimeoutSecond;
            mysqlResourceLocker.cleanCheckIntervalMs = this.cleanCheckIntervalMs;
            mysqlResourceLocker.renewalTimeMs = this.renewalTimeMs;
            mysqlResourceLocker.timeoutMs = this.timeoutMs;
            mysqlResourceLocker.init();
            return mysqlResourceLocker;
        }
    }

    private static class RenewalPackage {
        private final long slot;
        private final String key;
        private final String locker;

        public RenewalPackage(String locker, long slot, String key) {
            this.slot = slot;
            this.key = key;
            this.locker = locker;
        }

        public long getSlot() {
            return this.slot;
        }

        public String getKey() {
            return this.key;
        }

        public String getLocker() {
            return this.locker;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof RenewalPackage)) {
                return false;
            }
            RenewalPackage that = (RenewalPackage)o;
            return this.getSlot() == that.getSlot() && Objects.equals(this.getKey(), that.getKey()) && Objects.equals(this.getLocker(), that.getLocker());
        }

        public int hashCode() {
            return Objects.hash(this.getSlot(), this.getKey(), this.getLocker());
        }

        public String toString() {
            return new StringJoiner(", ", RenewalPackage.class.getSimpleName() + "[", "]").add("key='" + this.key + "'").add("locker='" + this.locker + "'").add("slot=" + this.slot).toString();
        }
    }
}

