/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.cc.tooling;

import com.xforceplus.cc.tooling.AbstractResourceLocker;
import com.xforceplus.cc.tooling.utils.ExecutorHelper;
import com.xforceplus.cc.tooling.utils.Locker;
import com.xforceplus.cc.tooling.utils.RedisLuaScriptWatchDog;
import com.xforceplus.cc.tooling.utils.StateKeys;
import io.lettuce.core.RedisClient;
import io.lettuce.core.ScriptOutputType;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.api.sync.RedisCommands;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisResourceLocker
extends AbstractResourceLocker {
    final Logger logger = LoggerFactory.getLogger(RedisResourceLocker.class);
    private static final long MIN_TTL_MS = 30000L;
    private static final String LOCK_SCRIPT = "local newLocker = ARGV[1];local ttl = ARGV[2];local curor = 0;for i=1, #KEYS, 1 do  local hasLocked = redis.call('EXISTS', KEYS[i]);  if hasLocked == 1 then    local locker = redis.call('HGET', KEYS[i], 'locker');    if (locker == newLocker) then      redis.call('HINCRBY', KEYS[i], 'acc', 1);      redis.call('PEXPIRE', KEYS[i], ttl);    else     return curor;    end;  else    redis.call('HMSET', KEYS[i], 'locker', newLocker, 'acc', 1);    redis.call('PEXPIRE', KEYS[i], ttl);  end;  curor = curor + 1;end;return curor;";
    private static final String UNLOCK_SCRIPT = "local freeLocker = ARGV[1];local failKeyIndexPoint = 1;local failKeyIndex = {};for i=1, #KEYS, 1 do  local hasLocked = redis.call('EXISTS', KEYS[i]);  if hasLocked == 1 then    local locker = redis.call('HGET', KEYS[i], 'locker');    if locker ~= freeLocker then      failKeyIndex[failKeyIndexPoint] = i - 1;      failKeyIndexPoint = failKeyIndexPoint + 1;    else      local acc = redis.call('HINCRBY', KEYS[i], 'acc', -1);      if acc == 0 then        redis.call('DEL', KEYS[i]);      end;    end;  end;end;return failKeyIndex;";
    private static final String RENEWAL_SCRIPT = "local locker = ARGV[1];local lockKey = KEYS[1];local ttl = ARGV[2];local hasLocked = redis.call('EXISTS', lockKey);if hasLocked == 1 then  local lockLocker = redis.call('HGET', lockKey, 'locker'); if locker ~= lockLocker then   return " + RenewalStatus.OTHER_LOCKER.getValue() + "; else   redis.call('pexpire', lockKey, ttl);   return " + RenewalStatus.SUCCESS.getValue() + "; end;end;return " + RenewalStatus.NOT_LOCK.getValue() + ";";
    private RedisClient redisClient;
    private RedisLuaScriptWatchDog redisLuaScriptWatchDog;
    private ExecutorService worker;
    private Map<String, LockInfo> liveLocks;
    private StatefulRedisConnection<String, String> connection;
    private RedisCommands<String, String> syncCommands;
    private String lockScriptSha;
    private String unLockScriptSha;
    private String renewalScriptSha;
    private volatile boolean running;
    private volatile boolean watchDagRunning;
    private long ttlMs;
    private long renewalMs;
    private String ttlMsString;

    public RedisResourceLocker() {
    }

    public RedisResourceLocker(RedisClient redisClient) {
        this.redisClient = redisClient;
    }

    public void setTtlMs(long ttlMs) {
        this.ttlMs = ttlMs;
    }

    public long getTtlMs() {
        return this.ttlMs;
    }

    public void init() throws Exception {
        if (this.redisClient == null) {
            throw new IllegalStateException("Invalid redisClient.");
        }
        this.connection = this.redisClient.connect();
        this.syncCommands = this.connection.sync();
        this.redisLuaScriptWatchDog = new RedisLuaScriptWatchDog(this.redisClient);
        this.lockScriptSha = this.redisLuaScriptWatchDog.watch(LOCK_SCRIPT);
        this.unLockScriptSha = this.redisLuaScriptWatchDog.watch(UNLOCK_SCRIPT);
        this.renewalScriptSha = this.redisLuaScriptWatchDog.watch(RENEWAL_SCRIPT);
        if (this.ttlMs < 30000L) {
            this.ttlMs = 30000L;
        }
        this.ttlMsString = Long.toString(this.ttlMs);
        this.renewalMs = this.ttlMs - (long)((float)this.ttlMs * 0.2f);
        this.liveLocks = new ConcurrentHashMap<String, LockInfo>();
        this.running = true;
        this.watchDagRunning = false;
        this.worker = Executors.newFixedThreadPool(1, ExecutorHelper.buildNameThreadFactory("redis-lock-watchdog"));
        this.worker.submit(new WatchDogTask());
        this.logger.info("The TTL of the lock is {} ms and the renewal interval is {} ms.", (Object)this.ttlMs, (Object)this.renewalMs);
    }

    public void destroy() throws Exception {
        this.running = false;
        while (this.watchDagRunning) {
            TimeUnit.MILLISECONDS.sleep(10L);
        }
        this.cleanAllLock();
        this.connection.close();
        ExecutorHelper.shutdownAndAwaitTermination(this.worker);
    }

    private void cleanAllLock() {
        Map<Locker, List<LockInfo>> groupLockInfos = this.liveLocks.values().stream().collect(Collectors.groupingBy(l -> ((LockInfo)l).locker));
        for (Map.Entry<Locker, List<LockInfo>> entry : groupLockInfos.entrySet()) {
            String[] keys = (String[])entry.getValue().stream().map(lockInfo -> lockInfo.getLockKey()).toArray(String[]::new);
            StateKeys stateKeys = new StateKeys(keys);
            this.doPriveUnLocks(entry.getKey(), stateKeys);
        }
    }

    @Override
    protected void doLocks(Locker locker, StateKeys stateKeys) {
        if (!this.running) {
            throw new IllegalStateException("It has been shut down.");
        }
        Object[] keys = stateKeys.getNoCompleteKeys();
        long size = (Long)this.syncCommands.evalsha(this.lockScriptSha, ScriptOutputType.INTEGER, keys, (Object[])new String[]{locker.getName(), this.ttlMsString});
        long now = System.currentTimeMillis();
        int i = 0;
        while ((long)i < size) {
            stateKeys.completed((String)keys[i]);
            this.liveLocks.put((String)keys[i], new LockInfo((String)keys[i], now, locker));
            ++i;
        }
    }

    @Override
    protected void doUnLocks(Locker locker, StateKeys stateKeys) {
        if (!this.running) {
            throw new IllegalStateException("It has been shut down.");
        }
        String[] keys = stateKeys.getNoCompleteKeys();
        int[] failedIndex = this.doPriveUnLocks(locker, stateKeys);
        for (int i = 0; i < failedIndex.length; ++i) {
            keys[failedIndex[i]] = null;
        }
        for (String key : keys) {
            if (key == null) continue;
            stateKeys.completed(key);
        }
    }

    @Override
    protected boolean doIsLocking(String key) {
        if (!this.liveLocks.containsKey(key)) {
            return this.syncCommands.exists((Object[])new String[]{key}) > 0L;
        }
        return true;
    }

    private int[] doPriveUnLocks(Locker locker, StateKeys stateKeys) {
        Object[] keys = stateKeys.getNoCompleteKeys();
        int[] failKeyIndex = ((List)this.syncCommands.evalsha(this.unLockScriptSha, ScriptOutputType.MULTI, keys, (Object[])new String[]{locker.getName()})).stream().mapToInt(i -> i.intValue()).sorted().toArray();
        int keyLen = keys.length;
        for (int i2 = 0; i2 < keyLen; ++i2) {
            this.liveLocks.remove(keys[i2]);
        }
        return failKeyIndex;
    }

    private class WatchDogTask
    implements Runnable {
        private WatchDogTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            RedisResourceLocker.this.watchDagRunning = true;
            long sleepMs = 100L;
            try {
                while (RedisResourceLocker.this.running) {
                    for (LockInfo lockInfo2 : RedisResourceLocker.this.liveLocks.values()) {
                        long nowMs = System.currentTimeMillis();
                        if (!this.needRenewal(lockInfo2.getLockKey(), nowMs, lockInfo2.getLastRenewalTimeMs())) continue;
                        long result = (Long)RedisResourceLocker.this.syncCommands.evalsha(RedisResourceLocker.this.renewalScriptSha, ScriptOutputType.INTEGER, (Object[])new String[]{lockInfo2.getLockKey()}, (Object[])new String[]{lockInfo2.getLocker().getName(), RedisResourceLocker.this.ttlMsString});
                        RenewalStatus status = RenewalStatus.getInstance(result);
                        if (RedisResourceLocker.this.logger.isDebugEnabled()) {
                            RedisResourceLocker.this.logger.debug("Renewal lock {}({}ms) {}.", new Object[]{lockInfo2.getLockKey(), nowMs - lockInfo2.getLastRenewalTimeMs(), status.name()});
                        }
                        if (RenewalStatus.SUCCESS == status) {
                            lockInfo2.setLastRenewalTimeMs(nowMs);
                            lockInfo2.setRenewalStatus(RenewalStatus.SUCCESS);
                            continue;
                        }
                        lockInfo2.setRenewalStatus(status);
                    }
                    RedisResourceLocker.this.liveLocks.values().removeIf(lockInfo -> lockInfo.getRenewalStatus() != RenewalStatus.SUCCESS);
                    LockSupport.parkNanos(this, TimeUnit.MILLISECONDS.toNanos(sleepMs));
                }
            }
            catch (Throwable ex) {
                RedisResourceLocker.this.logger.error(ex.getMessage(), ex);
            }
            finally {
                RedisResourceLocker.this.watchDagRunning = false;
            }
        }

        private boolean needRenewal(String key, long nowMs, long lastRenewalTimeMs) {
            if (RedisResourceLocker.this.liveLocks.containsKey(key)) {
                return nowMs - lastRenewalTimeMs >= RedisResourceLocker.this.renewalMs;
            }
            return false;
        }
    }

    private static class LockInfo {
        private final String lockKey;
        private long lastRenewalTimeMs;
        private final Locker locker;
        private RenewalStatus renewalStatus;

        public LockInfo(String lockKey, long lastRenewalTimeMs, Locker locker) {
            this.lockKey = lockKey;
            this.lastRenewalTimeMs = lastRenewalTimeMs;
            this.locker = locker;
            this.renewalStatus = RenewalStatus.SUCCESS;
        }

        public String getLockKey() {
            return this.lockKey;
        }

        public long getLastRenewalTimeMs() {
            return this.lastRenewalTimeMs;
        }

        public void setLastRenewalTimeMs(long lastRenewalTimeMs) {
            this.lastRenewalTimeMs = lastRenewalTimeMs;
        }

        public Locker getLocker() {
            return this.locker;
        }

        public RenewalStatus getRenewalStatus() {
            return this.renewalStatus;
        }

        public void setRenewalStatus(RenewalStatus renewalStatus) {
            this.renewalStatus = renewalStatus;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof LockInfo)) {
                return false;
            }
            LockInfo lockInfo = (LockInfo)o;
            return Objects.equals(this.getLockKey(), lockInfo.getLockKey());
        }

        public int hashCode() {
            return Objects.hash(this.getLockKey());
        }
    }

    private static enum RenewalStatus {
        UNKNOWN(0),
        SUCCESS(1),
        NOT_LOCK(2),
        OTHER_LOCKER(3);

        private final int statue;

        private RenewalStatus(int statue) {
            this.statue = statue;
        }

        public int getValue() {
            return this.statue;
        }

        public static RenewalStatus getInstance(int statue) {
            for (RenewalStatus status : RenewalStatus.values()) {
                if (statue != status.getValue()) continue;
                return status;
            }
            return UNKNOWN;
        }

        public static RenewalStatus getInstance(long statue) {
            return RenewalStatus.getInstance((int)statue);
        }
    }
}

