/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.cc.tooling.utils.timerwheel;

import com.xforceplus.cc.tooling.utils.ExecutorHelper;
import com.xforceplus.cc.tooling.utils.timerwheel.ITimerWheel;
import com.xforceplus.cc.tooling.utils.timerwheel.TimeoutNotification;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.IntStream;
import org.jctools.queues.MpscUnboundedArrayQueue;

public class TimerWheel<T>
implements ITimerWheel<T> {
    private static final int DEFAULT_SLOT_NUMBER = 512;
    private static final int DEFAULT_DURATION = 100;
    private final TimeUnit timeUnit = TimeUnit.MILLISECONDS;
    private final long duration;
    private final TimeoutNotification<T> notification;
    private final int slotNumber;
    private final Slot[] slots;
    private int currentSlot;
    private final ExecutorService worker;
    private final Queue<Timeout> waitingAddQueue;
    private final Map<T, Timeout> valueTimeoutIndex;

    public TimerWheel() {
        this(-1, -1L, null);
    }

    public TimerWheel(TimeoutNotification<T> notification) {
        this(-1, -1L, notification);
    }

    public TimerWheel(int slotNumber, long duration) {
        this(slotNumber, duration, null);
    }

    public TimerWheel(int slotNumber, long duration, TimeoutNotification<T> notification) {
        this.duration = duration <= 0L ? 100L : duration;
        this.slotNumber = slotNumber <= 3 ? 512 : slotNumber;
        this.notification = notification == null ? t -> 0L : notification;
        this.currentSlot = 0;
        this.slots = (Slot[])IntStream.range(0, this.slotNumber).mapToObj(i -> new Slot()).toArray(Slot[]::new);
        this.waitingAddQueue = new MpscUnboundedArrayQueue(16);
        this.valueTimeoutIndex = new ConcurrentHashMap<T, Timeout>(16);
        this.worker = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), ExecutorHelper.buildNameThreadFactory("time-wheel", true));
        this.worker.submit(new PointTask(this.duration));
    }

    public void destroy() throws Exception {
        this.worker.shutdownNow();
    }

    @Override
    public void add(T target, long duration) {
        if (target == null) {
            throw new NullPointerException("Target object is null!");
        }
        if (duration <= 0L) {
            return;
        }
        if (!this.valueTimeoutIndex.containsKey(target)) {
            Timeout<T> timeout = new Timeout<T>(target, duration);
            this.waitingAddQueue.offer(timeout);
            this.valueTimeoutIndex.put(target, timeout);
        }
    }

    @Override
    public void add(T target, Date expireDate) {
        this.add(target, expireDate.getTime() - System.currentTimeMillis());
    }

    @Override
    public boolean exist(T target) {
        if (target == null) {
            return false;
        }
        return this.valueTimeoutIndex.containsKey(target);
    }

    @Override
    public void remove(T target) {
        if (target == null) {
            return;
        }
        Timeout timeout = this.valueTimeoutIndex.get(target);
        if (timeout != null) {
            timeout.cancel();
            this.valueTimeoutIndex.remove(target);
        }
    }

    @Override
    public int size() {
        return this.valueTimeoutIndex.size();
    }

    private int calculateRuound(int virtualSlot) {
        return virtualSlot / this.slotNumber;
    }

    private int calculateActuallySlot(int virtualSlot) {
        return virtualSlot % this.slotNumber;
    }

    private int calculateVirtualSlot(long timeout) {
        return (int)((long)this.currentSlot + timeout / this.duration);
    }

    private class PointTask
    implements Runnable {
        private final long duration;

        public PointTask(long duration) {
            this.duration = duration;
        }

        @Override
        public void run() {
            do {
                Slot slot = TimerWheel.this.slots[TimerWheel.this.currentSlot];
                List expireList = slot.expire();
                this.processWaitingAddTimeout();
                TimerWheel.this.currentSlot = (TimerWheel.this.currentSlot + 1) % TimerWheel.this.slotNumber;
                try {
                    for (Timeout timeout : expireList) {
                        if (timeout.isCancelled()) continue;
                        long resultTime = TimerWheel.this.notification.notice(timeout.getValue());
                        TimerWheel.this.valueTimeoutIndex.remove(timeout.getValue());
                        if (resultTime <= 0L) continue;
                        TimerWheel.this.add(timeout.getValue(), resultTime);
                    }
                }
                catch (Throwable ex) {
                    ex.printStackTrace(System.err);
                }
                try {
                    TimerWheel.this.timeUnit.sleep(this.duration);
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
            } while (!Thread.interrupted());
        }

        private void processWaitingAddTimeout() {
            Timeout timeout = null;
            while ((timeout = (Timeout)TimerWheel.this.waitingAddQueue.poll()) != null) {
                if (timeout.isCancelled()) continue;
                long specialTimeout = timeout.getDuration();
                if (specialTimeout < this.duration) {
                    specialTimeout = this.duration;
                }
                int virtualSlotIndex = TimerWheel.this.calculateVirtualSlot(specialTimeout);
                int actuallySlotIndex = TimerWheel.this.calculateActuallySlot(virtualSlotIndex);
                int round = TimerWheel.this.calculateRuound(virtualSlotIndex);
                timeout.initRound(round);
                Slot slot = TimerWheel.this.slots[actuallySlotIndex];
                slot.add(timeout);
            }
        }
    }

    private static class Timeout<T> {
        private boolean cancelled;
        private int round;
        private final long duration;
        private final T value;

        public Timeout(T value, long duration) {
            this.value = value;
            this.duration = duration;
            this.round = 0;
        }

        public T getValue() {
            return this.value;
        }

        public long getDuration() {
            return this.duration;
        }

        public int getRound() {
            return this.round;
        }

        public void initRound(int round) {
            this.round = round;
        }

        public int reduceRound() {
            return this.round--;
        }

        public void cancel() {
            this.cancelled = true;
        }

        public boolean isCancelled() {
            return this.cancelled;
        }
    }

    private class Slot<T> {
        private final List<Timeout<T>> timeouts = new ArrayList<Timeout<T>>();

        private Slot() {
        }

        public void add(Timeout<T> timeout) {
            this.timeouts.add(timeout);
        }

        public List<Timeout<T>> expire() {
            ArrayList<Timeout<T>> expireList = new ArrayList<Timeout<T>>();
            Iterator<Timeout<T>> iter = this.timeouts.iterator();
            while (iter.hasNext()) {
                Timeout<T> timeout = iter.next();
                if (timeout.getRound() <= 0) {
                    expireList.add(timeout);
                    iter.remove();
                    continue;
                }
                timeout.reduceRound();
            }
            return expireList;
        }

        public void remove(Object target) {
            int notFound = -1;
            int index = -1;
            for (int i = 0; i < this.timeouts.size(); ++i) {
                if (!this.timeouts.get(i).getValue().equals(target)) continue;
                index = i;
                break;
            }
            if (index > -1) {
                this.timeouts.remove(index);
            }
        }

        public String toString() {
            return "Slot{timeouts=" + this.timeouts + '}';
        }
    }
}

