package com.xforceplus.metadata.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.metadata.entity.Cat;
import com.xforceplus.metadata.service.ICatService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author wangzheng
 * @date 2020-02-24
 */
@RestController
public class CatController {

  @Autowired
  private ICatService catServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param cat ${table.comment}
   * @return
   */
  @GetMapping("/cats" )
  public XfR getCats(XfPage page, Cat cat) {
    return XfR.ok(catServiceImpl.page(page, Wrappers.query(cat)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/cats/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(catServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param cat ${table.comment}
   * @return XfR
   */
  @PostMapping("/cats")
  public XfR save(@RequestBody Cat cat) {
     return XfR.ok(catServiceImpl.save(cat));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param cat ${table.comment}
   * @return XfR
   */
  @PutMapping("/cats/{id}")
  public XfR putUpdate(@RequestBody Cat cat,@PathVariable Long id) {
      cat.setId(id);
      return XfR.ok(catServiceImpl.updateById(cat));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param cat ${table.comment}
   * @return XfR
   */
  @PatchMapping("/cats/{id}")
  public XfR patchUpdate(@RequestBody Cat cat,@PathVariable Long id) {
      Cat upcat = catServiceImpl.getById(id);
      if(upcat != null){
        upcat = ObjectCopyUtils.copyProperties(cat,upcat,true);
      }
      return XfR.ok(catServiceImpl.updateById(upcat));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/cats/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(catServiceImpl.removeById(id));
  }

}