package com.xforceplus.compass.controller;


/**
 * 年度账单概要feign客户端
 *
 * @author ultraman
 * @date 2022-08-11
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.compass.entity.YearBill;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "compass")
public interface YearBillFeignApi {

  /**
   * 通过id查询年度账单概要
   * @param  id
   * @return R
   */
  @GetMapping("/yearBill/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增年度账单概要
   * @param yearBill 年度账单概要
   * @return R
   */
  @PostMapping("/yearBill/add")
  public R save(@RequestBody YearBill yearBill);

  /**
   * 修改年度账单概要
   * @param yearBill 年度账单概要
   * @return R
   */
  @PostMapping("/yearBill/update")
  public R updateById(@RequestBody YearBill yearBill);

  /**
   * 通过id删除年度账单概要
   * @param  id
   * @return R
   */
  @DeleteMapping("/yearBill/del/{id}" )
  public R removeById(@PathVariable Long id);

}