package com.xforceplus.compass.controller;


/**
 * 账单明细表feign客户端
 *
 * @author ultraman
 * @date 2022-05-30
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.compass.entity.BillDetails;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "compass")
public interface BillDetailsFeignApi {

  /**
   * 通过id查询账单明细表
   * @param  id
   * @return R
   */
  @GetMapping("/billDetails/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增账单明细表
   * @param billDetails 账单明细表
   * @return R
   */
  @PostMapping("/billDetails/add")
  public R save(@RequestBody BillDetails billDetails);

  /**
   * 修改账单明细表
   * @param billDetails 账单明细表
   * @return R
   */
  @PostMapping("/billDetails/update")
  public R updateById(@RequestBody BillDetails billDetails);

  /**
   * 通过id删除账单明细表
   * @param  id
   * @return R
   */
  @DeleteMapping("/billDetails/del/{id}" )
  public R removeById(@PathVariable Long id);

}