package com.xforceplus.compass.controller;


/**
 * 账单发票表feign客户端
 *
 * @author ultraman
 * @date 2022-05-30
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.compass.entity.BillInvoice;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "compass")
public interface BillInvoiceFeignApi {

  /**
   * 通过id查询账单发票表
   * @param  id
   * @return R
   */
  @GetMapping("/billInvoice/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增账单发票表
   * @param billInvoice 账单发票表
   * @return R
   */
  @PostMapping("/billInvoice/add")
  public R save(@RequestBody BillInvoice billInvoice);

  /**
   * 修改账单发票表
   * @param billInvoice 账单发票表
   * @return R
   */
  @PostMapping("/billInvoice/update")
  public R updateById(@RequestBody BillInvoice billInvoice);

  /**
   * 通过id删除账单发票表
   * @param  id
   * @return R
   */
  @DeleteMapping("/billInvoice/del/{id}" )
  public R removeById(@PathVariable Long id);

}