package com.xforceplus.compass.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2021-08-17
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class Bill implements Serializable {

  private static final long serialVersionUID=1L;

  private String billNo;

  private String billYy;

  private String billYm;

  private String status;

  private String sellerName;

  private String sellerTaxNo;

  private String purchaseName;

  private String purchaseTaxNo;

  private BigDecimal amountWithTax;

  private BigDecimal amountWithoutTax;

  private BigDecimal taxAmount;

  private String priceMethod;

  private BigDecimal rebateWithoutTax;

  private BigDecimal rebateWithTax;

  private BigDecimal rebateAmount;

  private Long id;

  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  private String remark;

  private String purchaserTenantId;

  private String settlementMode;

  private String settlementStatus;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("bill_no", billNo);
      map.put("bill_yy", billYy);
      map.put("bill_ym", billYm);
      map.put("status", status);
      map.put("seller_name", sellerName);
      map.put("seller_tax_no", sellerTaxNo);
      map.put("purchase_name", purchaseName);
      map.put("purchase_tax_no", purchaseTaxNo);
      map.put("amount_with_tax", amountWithTax);
      map.put("amount_without_tax", amountWithoutTax);
      map.put("tax_amount", taxAmount);
      map.put("price_method", priceMethod);
      map.put("rebate_without_tax", rebateWithoutTax);
      map.put("rebate_with_tax", rebateWithTax);
      map.put("rebate_amount", rebateAmount);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("remark", remark);
      map.put("purchaser_tenant_id", purchaserTenantId);
      map.put("settlement_mode", settlementMode);
      map.put("settlement_status", settlementStatus);
      return map;
  }

  public static Bill fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    Bill entity = new Bill();
    if(map.containsKey("bill_no")) {
      Object obj = map.get("bill_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBillNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bill_yy")) {
      Object obj = map.get("bill_yy");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBillYy((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bill_ym")) {
      Object obj = map.get("bill_ym");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBillYm((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_name")) {
      Object obj = map.get("seller_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_tax_no")) {
      Object obj = map.get("seller_tax_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchase_name")) {
      Object obj = map.get("purchase_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaseName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchase_tax_no")) {
      Object obj = map.get("purchase_tax_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaseTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amount_with_tax")) {
      Object obj = map.get("amount_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amount_without_tax")) {
      Object obj = map.get("amount_without_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("tax_amount")) {
      Object obj = map.get("tax_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("price_method")) {
      Object obj = map.get("price_method");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPriceMethod((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("rebate_without_tax")) {
      Object obj = map.get("rebate_without_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setRebateWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setRebateWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setRebateWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setRebateWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setRebateWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("rebate_with_tax")) {
      Object obj = map.get("rebate_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setRebateWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setRebateWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setRebateWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setRebateWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setRebateWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("rebate_amount")) {
      Object obj = map.get("rebate_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setRebateAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setRebateAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setRebateAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setRebateAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setRebateAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_tenant_id")) {
      Object obj = map.get("purchaser_tenant_id");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserTenantId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("settlement_mode")) {
      Object obj = map.get("settlement_mode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSettlementMode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("settlement_status")) {
      Object obj = map.get("settlement_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSettlementStatus((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
