package com.xforceplus.compass.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 账单状态
 * </p>
 *
 * @author ultraman
 * @since 2021-08-26
 */
public enum Status {

    _0("0", "新建"),
    _1("1", "计算中"),
    _2("2", "已发布"),
    _3("3", "已计算"),
    _4("4", "异常"),
    _5("5", "已取消"),
    _6("6", "已确认");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    Status(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static Status fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            case "6":
                return _6;
            default:
                return null;
        }
    }
}
