package com.xforceplus.compass.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2021-08-26
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class BillDetails implements Serializable {

  private static final long serialVersionUID=1L;

  private Long billInvoiceId;

  private String itemName;

  private String goodsTaxNo;

  private BigDecimal quantity;

  private BigDecimal unitPrice;

  private String itemSpec;

  private String quantityUnit;

  private BigDecimal alreadyMakeAmountWithoutTax;

  private BigDecimal alreadyMakeAmountWithTax;

  private BigDecimal alreadyMakeAmount;

  private BigDecimal rate;

  private String salesBillNo;

  private String salesBillItemNo;

  private BigDecimal rebateWithoutTax;

  private BigDecimal rebateWithTax;

  private BigDecimal rebateAmount;

  private Long rebateRate;

  private String projectAddr;

  private String settlementCycle;

  private Long id;

  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("bill_invoice_id", billInvoiceId);
      map.put("item_name", itemName);
      map.put("goods_tax_no", goodsTaxNo);
      map.put("quantity", quantity);
      map.put("unit_price", unitPrice);
      map.put("item_spec", itemSpec);
      map.put("quantity_unit", quantityUnit);
      map.put("already_make_amount_without_tax", alreadyMakeAmountWithoutTax);
      map.put("already_make_amount_with_tax", alreadyMakeAmountWithTax);
      map.put("already_make_amount", alreadyMakeAmount);
      map.put("rate", rate);
      map.put("sales_bill_no", salesBillNo);
      map.put("sales_bill_item_no", salesBillItemNo);
      map.put("rebate_without_tax", rebateWithoutTax);
      map.put("rebate_with_tax", rebateWithTax);
      map.put("rebate_amount", rebateAmount);
      map.put("rebate_rate", rebateRate);
      map.put("project_addr", projectAddr);
      map.put("settlement_cycle", settlementCycle);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      return map;
  }

  public static BillDetails fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    BillDetails entity = new BillDetails();
    if(map.containsKey("bill_invoice_id")) {
      Object obj = map.get("bill_invoice_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setBillInvoiceId((Long)obj);
        } else if(obj instanceof String) {
          entity.setBillInvoiceId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setBillInvoiceId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("item_name")) {
      Object obj = map.get("item_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setItemName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("goods_tax_no")) {
      Object obj = map.get("goods_tax_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setGoodsTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("quantity")) {
      Object obj = map.get("quantity");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setQuantity((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setQuantity(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setQuantity(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setQuantity(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setQuantity(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("unit_price")) {
      Object obj = map.get("unit_price");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setUnitPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setUnitPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setUnitPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setUnitPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUnitPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("item_spec")) {
      Object obj = map.get("item_spec");
      if(obj != null) {
        if(obj instanceof String){
          entity.setItemSpec((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("quantity_unit")) {
      Object obj = map.get("quantity_unit");
      if(obj != null) {
        if(obj instanceof String){
          entity.setQuantityUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("already_make_amount_without_tax")) {
      Object obj = map.get("already_make_amount_without_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAlreadyMakeAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAlreadyMakeAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAlreadyMakeAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setAlreadyMakeAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAlreadyMakeAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("already_make_amount_with_tax")) {
      Object obj = map.get("already_make_amount_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAlreadyMakeAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAlreadyMakeAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAlreadyMakeAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setAlreadyMakeAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAlreadyMakeAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("already_make_amount")) {
      Object obj = map.get("already_make_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAlreadyMakeAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAlreadyMakeAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAlreadyMakeAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setAlreadyMakeAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAlreadyMakeAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("rate")) {
      Object obj = map.get("rate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("sales_bill_no")) {
      Object obj = map.get("sales_bill_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSalesBillNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sales_bill_item_no")) {
      Object obj = map.get("sales_bill_item_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSalesBillItemNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("rebate_without_tax")) {
      Object obj = map.get("rebate_without_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setRebateWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setRebateWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setRebateWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setRebateWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setRebateWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("rebate_with_tax")) {
      Object obj = map.get("rebate_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setRebateWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setRebateWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setRebateWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setRebateWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setRebateWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("rebate_amount")) {
      Object obj = map.get("rebate_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setRebateAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setRebateAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setRebateAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setRebateAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setRebateAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("rebate_rate")) {
      Object obj = map.get("rebate_rate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setRebateRate((Long)obj);
        } else if(obj instanceof String) {
          entity.setRebateRate(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setRebateRate(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("project_addr")) {
      Object obj = map.get("project_addr");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProjectAddr((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("settlement_cycle")) {
      Object obj = map.get("settlement_cycle");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSettlementCycle((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
