package com.xforceplus.compass.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 账单明细表
 * </p>
 *
 * @author ultraman
 * @since 2025-05-19
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class BillDetails implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 账单发票ID
   */
  private Long billInvoiceId;

  /**
   * 商品名称
   */
  private String itemName;

  /**
   * 税收分类编码
   */
  private String goodsTaxNo;

  /**
   * 数量
   */
  private BigDecimal quantity;

  /**
   * 含税单价
   */
  private BigDecimal unitPrice;

  /**
   * 规格型号
   */
  private String itemSpec;

  /**
   * 数量单位
   */
  private String quantityUnit;

  /**
   * 已开票金额（不含税）
   */
  private BigDecimal alreadyMakeAmountWithoutTax;

  /**
   * 已开票金额（含税）
   */
  private BigDecimal alreadyMakeAmountWithTax;

  /**
   * 已开票税额
   */
  private BigDecimal alreadyMakeAmount;

  /**
   * 税率
   */
  private BigDecimal rate;

  /**
   * 账期-业务单号
   */
  private String salesBillNo;

  /**
   * 账期-业务单明细号
   */
  private String salesBillItemNo;

  /**
   * 返利金额（不含税）
   */
  private BigDecimal rebateWithoutTax;

  /**
   * 返利金额（含税）
   */
  private BigDecimal rebateWithTax;

  /**
   * 返利税额
   */
  private BigDecimal rebateAmount;

  /**
   * 返利利率
   */
  private Long rebateRate;

  /**
   * 账期-项目地点
   */
  private String projectAddr;

  /**
   * 结算期间
   */
  private String settlementCycle;

  /**
   * id
   */
  private Long id;

  /**
   * 租户id
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 发票明细ID
   */
  private Long itemId;

  /**
   * 返利金额
   */
  private BigDecimal rebateMoney;

  /**
   * 组织树
   */
  private String orgTree;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("bill_invoice_id", billInvoiceId);
      map.put("item_name", itemName);
      map.put("goods_tax_no", goodsTaxNo);
      map.put("quantity", quantity);
      map.put("unit_price", unitPrice);
      map.put("item_spec", itemSpec);
      map.put("quantity_unit", quantityUnit);
      map.put("already_make_amount_without_tax", alreadyMakeAmountWithoutTax);
      map.put("already_make_amount_with_tax", alreadyMakeAmountWithTax);
      map.put("already_make_amount", alreadyMakeAmount);
      map.put("rate", rate);
      map.put("sales_bill_no", salesBillNo);
      map.put("sales_bill_item_no", salesBillItemNo);
      map.put("rebate_without_tax", rebateWithoutTax);
      map.put("rebate_with_tax", rebateWithTax);
      map.put("rebate_amount", rebateAmount);
      map.put("rebate_rate", rebateRate);
      map.put("project_addr", projectAddr);
      map.put("settlement_cycle", settlementCycle);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("item_id", itemId);
      map.put("rebate_money", rebateMoney);
      map.put("org_tree", orgTree);

      return map;
  }

  public static BillDetails fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    BillDetails entity = new BillDetails();
    if(map.containsKey("bill_invoice_id")) {
      Object obj = map.get("bill_invoice_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setBillInvoiceId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBillInvoiceId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setBillInvoiceId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("item_name")) {
      Object obj = map.get("item_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setItemName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("goods_tax_no")) {
      Object obj = map.get("goods_tax_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGoodsTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("quantity")) {
      Object obj = map.get("quantity");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setQuantity((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setQuantity(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setQuantity(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setQuantity(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setQuantity(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("unit_price")) {
      Object obj = map.get("unit_price");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setUnitPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setUnitPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setUnitPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUnitPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUnitPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("item_spec")) {
      Object obj = map.get("item_spec");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setItemSpec((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("quantity_unit")) {
      Object obj = map.get("quantity_unit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setQuantityUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("already_make_amount_without_tax")) {
      Object obj = map.get("already_make_amount_without_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAlreadyMakeAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAlreadyMakeAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAlreadyMakeAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAlreadyMakeAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAlreadyMakeAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("already_make_amount_with_tax")) {
      Object obj = map.get("already_make_amount_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAlreadyMakeAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAlreadyMakeAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAlreadyMakeAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAlreadyMakeAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAlreadyMakeAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("already_make_amount")) {
      Object obj = map.get("already_make_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAlreadyMakeAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAlreadyMakeAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAlreadyMakeAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAlreadyMakeAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAlreadyMakeAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("rate")) {
      Object obj = map.get("rate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("sales_bill_no")) {
      Object obj = map.get("sales_bill_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSalesBillNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sales_bill_item_no")) {
      Object obj = map.get("sales_bill_item_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSalesBillItemNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("rebate_without_tax")) {
      Object obj = map.get("rebate_without_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setRebateWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setRebateWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setRebateWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setRebateWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setRebateWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("rebate_with_tax")) {
      Object obj = map.get("rebate_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setRebateWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setRebateWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setRebateWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setRebateWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setRebateWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("rebate_amount")) {
      Object obj = map.get("rebate_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setRebateAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setRebateAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setRebateAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setRebateAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setRebateAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("rebate_rate")) {
      Object obj = map.get("rebate_rate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setRebateRate((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setRebateRate(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setRebateRate(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("project_addr")) {
      Object obj = map.get("project_addr");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProjectAddr((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("settlement_cycle")) {
      Object obj = map.get("settlement_cycle");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSettlementCycle((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("item_id")) {
      Object obj = map.get("item_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setItemId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setItemId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setItemId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("rebate_money")) {
      Object obj = map.get("rebate_money");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setRebateMoney((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setRebateMoney(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setRebateMoney(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setRebateMoney(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setRebateMoney(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrgTree((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("bill_invoice_id")) {
      Object obj = map.get("bill_invoice_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setBillInvoiceId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setBillInvoiceId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setBillInvoiceId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("item_name")) {
      Object obj = map.get("item_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setItemName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("goods_tax_no")) {
      Object obj = map.get("goods_tax_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setGoodsTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("quantity")) {
      Object obj = map.get("quantity");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setQuantity((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setQuantity(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setQuantity(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setQuantity(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setQuantity(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("unit_price")) {
      Object obj = map.get("unit_price");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setUnitPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setUnitPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setUnitPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUnitPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setUnitPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("item_spec")) {
      Object obj = map.get("item_spec");
      if(obj != null) {
        if(obj instanceof String) {
          this.setItemSpec((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("quantity_unit")) {
      Object obj = map.get("quantity_unit");
      if(obj != null) {
        if(obj instanceof String) {
          this.setQuantityUnit((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("already_make_amount_without_tax")) {
      Object obj = map.get("already_make_amount_without_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAlreadyMakeAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAlreadyMakeAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAlreadyMakeAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAlreadyMakeAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAlreadyMakeAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("already_make_amount_with_tax")) {
      Object obj = map.get("already_make_amount_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAlreadyMakeAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAlreadyMakeAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAlreadyMakeAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAlreadyMakeAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAlreadyMakeAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("already_make_amount")) {
      Object obj = map.get("already_make_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAlreadyMakeAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAlreadyMakeAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAlreadyMakeAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAlreadyMakeAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAlreadyMakeAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("rate")) {
      Object obj = map.get("rate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("sales_bill_no")) {
      Object obj = map.get("sales_bill_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSalesBillNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sales_bill_item_no")) {
      Object obj = map.get("sales_bill_item_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSalesBillItemNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("rebate_without_tax")) {
      Object obj = map.get("rebate_without_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setRebateWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setRebateWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setRebateWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setRebateWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setRebateWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("rebate_with_tax")) {
      Object obj = map.get("rebate_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setRebateWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setRebateWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setRebateWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setRebateWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setRebateWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("rebate_amount")) {
      Object obj = map.get("rebate_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setRebateAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setRebateAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setRebateAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setRebateAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setRebateAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("rebate_rate")) {
      Object obj = map.get("rebate_rate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setRebateRate((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setRebateRate(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setRebateRate(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("project_addr")) {
      Object obj = map.get("project_addr");
      if(obj != null) {
        if(obj instanceof String) {
          this.setProjectAddr((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("settlement_cycle")) {
      Object obj = map.get("settlement_cycle");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSettlementCycle((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("item_id")) {
      Object obj = map.get("item_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setItemId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setItemId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setItemId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("rebate_money")) {
      Object obj = map.get("rebate_money");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setRebateMoney((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setRebateMoney(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setRebateMoney(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setRebateMoney(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setRebateMoney(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrgTree((String)obj);
        }
      } else {
      }
    }
  }
}
