package com.xforceplus.compass.metadata;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.xforceplus.ultraman.bocp.gen.typed.TypedField;


/**
* <p>
    * 
    * </p>
*
* @author ultraman
* @since 2025-09-23
*/

public class EntityMeta {

    public interface Bill {
        static Long id() {
            return 1423582025706938370L;
        }
        static String code() {
            return "bill";
        }
        TypedField<String> BILL_NO = new TypedField<>(String.class, "bill_no");
        TypedField<String> BILL_YY = new TypedField<>(String.class, "bill_yy");
        TypedField<String> BILL_YM = new TypedField<>(String.class, "bill_ym");
        TypedField<String> STATUS = new TypedField<>(String.class, "status");
        TypedField<String> SELLER_NAME = new TypedField<>(String.class, "seller_name");
        TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "seller_tax_no");
        TypedField<String> PURCHASE_NAME = new TypedField<>(String.class, "purchase_name");
        TypedField<String> PURCHASE_TAX_NO = new TypedField<>(String.class, "purchase_tax_no");
        TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "amount_with_tax");
        TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "amount_without_tax");
        TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "tax_amount");
        TypedField<String> PRICE_METHOD = new TypedField<>(String.class, "price_method");
        TypedField<BigDecimal> REBATE_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "rebate_without_tax");
        TypedField<BigDecimal> REBATE_WITH_TAX = new TypedField<>(BigDecimal.class, "rebate_with_tax");
        TypedField<BigDecimal> REBATE_AMOUNT = new TypedField<>(BigDecimal.class, "rebate_amount");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> REMARK = new TypedField<>(String.class, "remark");
        TypedField<String> PURCHASER_TENANT_ID = new TypedField<>(String.class, "purchaser_tenant_id");
        TypedField<String> SETTLEMENT_MODE = new TypedField<>(String.class, "settlement_mode");
        TypedField<String> SETTLEMENT_STATUS = new TypedField<>(String.class, "settlement_status");
        TypedField<String> SELLER_TENANT_ID = new TypedField<>(String.class, "seller_tenant_id");
        TypedField<LocalDateTime> SETTLEMENT_CYCLE = new TypedField<>(LocalDateTime.class, "settlement_cycle");
        TypedField<String> SELLER_STATUS = new TypedField<>(String.class, "seller_status");
        TypedField<String> ERROR_REMARK = new TypedField<>(String.class, "error_remark");
        TypedField<BigDecimal> GENERAL_WITH_TAX_REBATE = new TypedField<>(BigDecimal.class, "general_with_tax_rebate");
        TypedField<BigDecimal> SPECIAL_WITHOUT_TAX_REBATE = new TypedField<>(BigDecimal.class, "special_without_tax_rebate");
        TypedField<BigDecimal> TOTAL_REBATE = new TypedField<>(BigDecimal.class, "total_rebate");
        TypedField<String> ORG_TREE = new TypedField<>(String.class, "org_tree");
    }
    public interface BillInvoice {
        static Long id() {
            return 1423584766047068162L;
        }
        static String code() {
            return "billInvoice";
        }
        TypedField<Long> BILL_ID = new TypedField<>(Long.class, "bill_id");
        TypedField<String> BILL_NO = new TypedField<>(String.class, "bill_no");
        TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoice_no");
        TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "invoice_code");
        TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "invoice_type");
        TypedField<String> PAPER_DREW_DATE = new TypedField<>(String.class, "paper_drew_date");
        TypedField<String> STATUS = new TypedField<>(String.class, "status");
        TypedField<String> RED_FLAG = new TypedField<>(String.class, "red_flag");
        TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "amount_with_tax");
        TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "tax_amount");
        TypedField<BigDecimal> TOTAL_AMOUNT_TAX_NUM = new TypedField<>(BigDecimal.class, "total_amount_tax_num");
        TypedField<String> SETTLEMENT_MODE = new TypedField<>(String.class, "settlement_mode");
        TypedField<String> SCAN_STATUS = new TypedField<>(String.class, "scan_status");
        TypedField<String> SCAN_TIME = new TypedField<>(String.class, "scan_time");
        TypedField<String> AUTH_STATUS = new TypedField<>(String.class, "auth_status");
        TypedField<String> AUTH_TIME = new TypedField<>(String.class, "auth_time");
        TypedField<String> INVOICE_COLOR = new TypedField<>(String.class, "invoice_color");
        TypedField<BigDecimal> REBATE_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "rebate_without_tax");
        TypedField<BigDecimal> REBATE_WITH_TAX = new TypedField<>(BigDecimal.class, "rebate_with_tax");
        TypedField<BigDecimal> REBATE_AMOUNT = new TypedField<>(BigDecimal.class, "rebate_amount");
        TypedField<String> SETTLEMENT_CYCLE = new TypedField<>(String.class, "settlement_cycle");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> RED_NOTIFICATION_NO = new TypedField<>(String.class, "red_notification_no");
        TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "amount_without_tax");
        TypedField<String> PROJECT_ADDR = new TypedField<>(String.class, "project_addr");
        TypedField<String> RED_TIME = new TypedField<>(String.class, "red_time");
        TypedField<BigDecimal> TOTAL_REBATE = new TypedField<>(BigDecimal.class, "total_rebate");
        TypedField<String> INVOICE = new TypedField<>(String.class, "invoice");
        TypedField<String> ORG_TREE = new TypedField<>(String.class, "org_tree");
    }
    public interface BillDetails {
        static Long id() {
            return 1423587553002692609L;
        }
        static String code() {
            return "billDetails";
        }
        TypedField<Long> BILL_INVOICE_ID = new TypedField<>(Long.class, "bill_invoice_id");
        TypedField<String> ITEM_NAME = new TypedField<>(String.class, "item_name");
        TypedField<String> GOODS_TAX_NO = new TypedField<>(String.class, "goods_tax_no");
        TypedField<BigDecimal> QUANTITY = new TypedField<>(BigDecimal.class, "quantity");
        TypedField<BigDecimal> UNIT_PRICE = new TypedField<>(BigDecimal.class, "unit_price");
        TypedField<String> ITEM_SPEC = new TypedField<>(String.class, "item_spec");
        TypedField<String> QUANTITY_UNIT = new TypedField<>(String.class, "quantity_unit");
        TypedField<BigDecimal> ALREADY_MAKE_AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "already_make_amount_without_tax");
        TypedField<BigDecimal> ALREADY_MAKE_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "already_make_amount_with_tax");
        TypedField<BigDecimal> ALREADY_MAKE_AMOUNT = new TypedField<>(BigDecimal.class, "already_make_amount");
        TypedField<BigDecimal> RATE = new TypedField<>(BigDecimal.class, "rate");
        TypedField<String> SALES_BILL_NO = new TypedField<>(String.class, "sales_bill_no");
        TypedField<String> SALES_BILL_ITEM_NO = new TypedField<>(String.class, "sales_bill_item_no");
        TypedField<BigDecimal> REBATE_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "rebate_without_tax");
        TypedField<BigDecimal> REBATE_WITH_TAX = new TypedField<>(BigDecimal.class, "rebate_with_tax");
        TypedField<BigDecimal> REBATE_AMOUNT = new TypedField<>(BigDecimal.class, "rebate_amount");
        TypedField<Long> REBATE_RATE = new TypedField<>(Long.class, "rebate_rate");
        TypedField<String> PROJECT_ADDR = new TypedField<>(String.class, "project_addr");
        TypedField<String> SETTLEMENT_CYCLE = new TypedField<>(String.class, "settlement_cycle");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<Long> ITEM_ID = new TypedField<>(Long.class, "item_id");
        TypedField<BigDecimal> REBATE_MONEY = new TypedField<>(BigDecimal.class, "rebate_money");
        TypedField<String> ORG_TREE = new TypedField<>(String.class, "org_tree");
    }
    public interface YearBill {
        static Long id() {
            return 1499221813372588033L;
        }
        static String code() {
            return "yearBill";
        }
        TypedField<String> YEAR = new TypedField<>(String.class, "year");
        TypedField<String> SELLER_NAME = new TypedField<>(String.class, "seller_name");
        TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "seller_tax_no");
        TypedField<String> SELLER_TENANT_ID = new TypedField<>(String.class, "seller_tenant_id");
        TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "purchaser_name");
        TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "purchaser_tax_no");
        TypedField<String> PURCHASER_TENANT_ID = new TypedField<>(String.class, "purchaser_tenant_id");
        TypedField<String> STATUS = new TypedField<>(String.class, "status");
        TypedField<String> ERROR_REMARK = new TypedField<>(String.class, "error_remark");
        TypedField<BigDecimal> GENERAL_WITH_TAX_REBATE = new TypedField<>(BigDecimal.class, "general_with_tax_rebate");
        TypedField<BigDecimal> SPECIAL_WITHOUT_TAX_REBATE = new TypedField<>(BigDecimal.class, "special_without_tax_rebate");
        TypedField<BigDecimal> TOTAL_REBATE = new TypedField<>(BigDecimal.class, "total_rebate");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> YEAR_BILL_NO = new TypedField<>(String.class, "year_bill_no");
        TypedField<String> CANCEL_REMARK = new TypedField<>(String.class, "cancel_remark");
        TypedField<String> ORG_TREE = new TypedField<>(String.class, "org_tree");
    }
    public interface YearBillMain {
        static Long id() {
            return 1499244937229045761L;
        }
        static String code() {
            return "yearBillMain";
        }
        TypedField<String> SALESBILL_NO = new TypedField<>(String.class, "salesbill_no");
        TypedField<String> SALESBILL_TYPE = new TypedField<>(String.class, "salesbill_type");
        TypedField<String> SELLER_NO = new TypedField<>(String.class, "seller_no");
        TypedField<String> SELLER_NAME = new TypedField<>(String.class, "seller_name");
        TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "seller_tax_no");
        TypedField<String> SELLER_TEL = new TypedField<>(String.class, "seller_tel");
        TypedField<String> SELLER_ADDRESS = new TypedField<>(String.class, "seller_address");
        TypedField<String> SELLER_BANK_NAME = new TypedField<>(String.class, "seller_bank_name");
        TypedField<String> SELLER_BANK_ACCOUNT = new TypedField<>(String.class, "seller_bank_account");
        TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "purchaser_no");
        TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "purchaser_name");
        TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "purchaser_tax_no");
        TypedField<String> PURCHASER_TEL = new TypedField<>(String.class, "purchaser_tel");
        TypedField<String> PURCHASER_ADDRESS = new TypedField<>(String.class, "purchaser_address");
        TypedField<String> PURCHASER_BANK_NAME = new TypedField<>(String.class, "purchaser_bank_name");
        TypedField<String> PURCHASER_BANK_ACCOUNT = new TypedField<>(String.class, "purchaser_bank_account");
        TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "invoice_type");
        TypedField<String> PRICE_METHOD = new TypedField<>(String.class, "price_method");
        TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "amount_with_tax");
        TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "amount_without_tax");
        TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "tax_amount");
        TypedField<String> ORIGIN_INVOICE_CODE = new TypedField<>(String.class, "origin_invoice_code");
        TypedField<String> ORIGIN_INVOICE_NO = new TypedField<>(String.class, "origin_invoice_no");
        TypedField<String> UPLOAD_STATUS = new TypedField<>(String.class, "upload_status");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> UPLOAD_MSG_ID = new TypedField<>(String.class, "upload_msg_id");
        TypedField<String> ERROR_REMARK = new TypedField<>(String.class, "error_remark");
        TypedField<String> YEAR_BILL_NO = new TypedField<>(String.class, "year_bill_no");
        TypedField<String> ORG_TREE = new TypedField<>(String.class, "org_tree");
        /**
         * 对一关联关系 关联对象 yearBill
         */
        TypedField<Long> YEAR_BILL_ID = new TypedField<>(Long.class, "yearBill.id");
    }
    public interface YearBillDetail {
        static Long id() {
            return 1499248408695083010L;
        }
        static String code() {
            return "yearBillDetail";
        }
        TypedField<String> SALESBILL_NO = new TypedField<>(String.class, "salesbill_no");
        TypedField<String> ITEM_NAME = new TypedField<>(String.class, "item_name");
        TypedField<String> ITEM_SPEC = new TypedField<>(String.class, "item_spec");
        TypedField<String> GOODS_TAX_NO = new TypedField<>(String.class, "goods_tax_no");
        TypedField<BigDecimal> UNIT_PRICE = new TypedField<>(BigDecimal.class, "unit_price");
        TypedField<BigDecimal> QUANTITY = new TypedField<>(BigDecimal.class, "quantity");
        TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "amount_with_tax");
        TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "amount_without_tax");
        TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "tax_amount");
        TypedField<BigDecimal> TAX_RATE = new TypedField<>(BigDecimal.class, "tax_rate");
        TypedField<String> TAX_PRE = new TypedField<>(String.class, "tax_pre");
        TypedField<String> TAX_PRE_CON = new TypedField<>(String.class, "tax_pre_con");
        TypedField<String> ZERO_TAX = new TypedField<>(String.class, "zero_tax");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<Long> YEAR_BILL_ID = new TypedField<>(Long.class, "year_bill_id");
        TypedField<String> YEAR_BILL_NO = new TypedField<>(String.class, "year_bill_no");
        TypedField<String> ORG_TREE = new TypedField<>(String.class, "org_tree");
        /**
         * 对一关联关系 关联对象 yearBillMain
         */
        TypedField<Long> YEAR_BILL_MAIN_ID = new TypedField<>(Long.class, "yearBillMain.id");
    }
    public interface InvoiceDetail {
        static Long id() {
            return 1499741904803536898L;
        }
        static String code() {
            return "invoiceDetail";
        }
        TypedField<Long> BILL_ID = new TypedField<>(Long.class, "bill_id");
        TypedField<String> BILL_NO = new TypedField<>(String.class, "bill_no");
        TypedField<Long> BILL_INVOICE_ID = new TypedField<>(Long.class, "bill_invoice_id");
        TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "invoice_code");
        TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoice_no");
        TypedField<String> GOODS_TAX_NO = new TypedField<>(String.class, "goods_tax_no");
        TypedField<BigDecimal> UNIT_PRICE = new TypedField<>(BigDecimal.class, "unit_price");
        TypedField<BigDecimal> QUANTITY = new TypedField<>(BigDecimal.class, "quantity");
        TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "amount_with_tax");
        TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "amount_without_tax");
        TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "tax_amount");
        TypedField<BigDecimal> TAX_RATE = new TypedField<>(BigDecimal.class, "tax_rate");
        TypedField<String> TAX_PRE = new TypedField<>(String.class, "tax_pre");
        TypedField<String> TAX_PRE_CON = new TypedField<>(String.class, "tax_pre_con");
        TypedField<String> ZERO_TAX = new TypedField<>(String.class, "zero_tax");
        TypedField<String> INVOICE_ITEM = new TypedField<>(String.class, "invoice_item");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> CARGO_NAME = new TypedField<>(String.class, "cargo_name");
        TypedField<String> QUANLITY_UNIT = new TypedField<>(String.class, "quanlity_unit");
        TypedField<String> ORG_TREE = new TypedField<>(String.class, "org_tree");
    }
    public interface SalesbillUpload {
        static Long id() {
            return 1526052519228145666L;
        }
        static String code() {
            return "salesbillUpload";
        }
        TypedField<String> SALESBILLNO = new TypedField<>(String.class, "salesbillNo");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> PURCHASERNO = new TypedField<>(String.class, "purchaserNo");
        TypedField<String> SELLERNO = new TypedField<>(String.class, "sellerNo");
        TypedField<String> SELLERNAME = new TypedField<>(String.class, "sellerName");
        TypedField<String> UPLOADSTATUS = new TypedField<>(String.class, "uploadStatus");
        TypedField<String> BILLINGSETPERIOD = new TypedField<>(String.class, "billingSetPeriod");
        TypedField<LocalDateTime> UPLOADDATE = new TypedField<>(LocalDateTime.class, "uploadDate");
        TypedField<String> ORDERNO = new TypedField<>(String.class, "orderNo");
        TypedField<String> RECEIPTNO = new TypedField<>(String.class, "receiptNo");
        TypedField<String> PROCESSREMARK = new TypedField<>(String.class, "processRemark");
        TypedField<String> AMOUNTWITHOUTTAX = new TypedField<>(String.class, "amountWithoutTax");
        TypedField<String> SERIALNO = new TypedField<>(String.class, "serialNo");
        TypedField<String> ORG_TREE = new TypedField<>(String.class, "org_tree");
    }
    public interface MiroBillDetails {
        static Long id() {
            return 1528720721171120130L;
        }
        static String code() {
            return "miroBillDetails";
        }
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> SETTLEMENT_NO = new TypedField<>(String.class, "settlement_no");
        TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoice_no");
        TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "invoice_code");
        TypedField<String> IS_IMAGE = new TypedField<>(String.class, "is_image");
        TypedField<String> SETTLEMENT_SEQ = new TypedField<>(String.class, "settlement_seq");
        TypedField<LocalDateTime> INVOICE_TIME = new TypedField<>(LocalDateTime.class, "invoice_time");
        TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "invoice_type");
        TypedField<LocalDateTime> INVOICE_SCAN_TIME = new TypedField<>(LocalDateTime.class, "invoice_scan_time");
        TypedField<String> INVOICE_VERIFY = new TypedField<>(String.class, "invoice_verify");
        TypedField<BigDecimal> INVOICE_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "invoice_amount_with_tax");
        TypedField<String> INVOICESTATUS = new TypedField<>(String.class, "invoiceStatus");
        TypedField<BigDecimal> REBATE_RATE = new TypedField<>(BigDecimal.class, "rebate_rate");
        TypedField<String> START_TIME = new TypedField<>(String.class, "start_time");
        TypedField<String> END_TIME = new TypedField<>(String.class, "end_time");
        TypedField<String> GL_ACCOUNT = new TypedField<>(String.class, "gl_account");
        TypedField<BigDecimal> INVOICE_AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "invoice_amount_without_tax");
        TypedField<BigDecimal> INVOICE_TAX = new TypedField<>(BigDecimal.class, "invoice_tax");
        TypedField<String> ORDER_NO = new TypedField<>(String.class, "order_no");
        TypedField<String> EXTS = new TypedField<>(String.class, "exts");
        TypedField<String> PDFURL = new TypedField<>(String.class, "pdfUrl");
        TypedField<String> IMGURL = new TypedField<>(String.class, "imgUrl");
        TypedField<String> INVOICEORIG = new TypedField<>(String.class, "invoiceOrig");
        TypedField<String> SELLER_ADDRESS = new TypedField<>(String.class, "seller_address");
        TypedField<String> SELLER_PHONE = new TypedField<>(String.class, "seller_phone");
        TypedField<String> ORIGIN_INVOICE_NO = new TypedField<>(String.class, "origin_invoice_no");
        TypedField<String> ORG_TREE = new TypedField<>(String.class, "org_tree");
        /**
         * 对一关联关系 关联对象 miroResult
         */
        TypedField<Long> MIRO_RESULT_OTM_DETAILS_ID = new TypedField<>(Long.class, "miroResultOtmDetails.id");
    }
    public interface MiroResult {
        static Long id() {
            return 1528728888462475265L;
        }
        static String code() {
            return "miroResult";
        }
        TypedField<String> SETTLEMENT_NO = new TypedField<>(String.class, "settlement_no");
        TypedField<String> SETTLEMENT_SEQ = new TypedField<>(String.class, "settlement_seq");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<LocalDateTime> SETTLEMENT_PERIOD = new TypedField<>(LocalDateTime.class, "settlement_period");
        TypedField<String> SETTLEMENT_STATUS = new TypedField<>(String.class, "settlement_status");
        TypedField<String> ERROR_MSG = new TypedField<>(String.class, "error_msg");
        TypedField<Long> SEND_COUNT = new TypedField<>(Long.class, "send_count");
        TypedField<String> SAP_INVOICE_DOCUMENT = new TypedField<>(String.class, "sap_invoice_document");
        TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "purchaser_name");
        TypedField<String> PURCHASER_TAX = new TypedField<>(String.class, "purchaser_tax");
        TypedField<String> SELLER_NAME = new TypedField<>(String.class, "seller_name");
        TypedField<String> SELLER_TAX = new TypedField<>(String.class, "seller_tax");
        TypedField<BigDecimal> SETTLEMENT_AMOUNT = new TypedField<>(BigDecimal.class, "settlement_amount");
        TypedField<String> PURCHASER_COMPANY_CODE = new TypedField<>(String.class, "purchaser_company_code");
        TypedField<String> SELLER_NO = new TypedField<>(String.class, "seller_no");
        TypedField<String> REQUEST_MESSAGE = new TypedField<>(String.class, "request_message");
        TypedField<String> IS_COORDINATION = new TypedField<>(String.class, "is_coordination");
        TypedField<String> IS_REBATE = new TypedField<>(String.class, "is_rebate");
        TypedField<LocalDateTime> SAP_INVOICE_DOCUMENT_TIME = new TypedField<>(LocalDateTime.class, "sap_invoice_document_time");
        TypedField<String> ORG_TREE = new TypedField<>(String.class, "org_tree");
    }
    public interface MiroOrderDetail {
        static Long id() {
            return 1531197507019022338L;
        }
        static String code() {
            return "miroOrderDetail";
        }
        TypedField<String> ORDER_NO = new TypedField<>(String.class, "order_no");
        TypedField<String> ORDER_ITEM = new TypedField<>(String.class, "order_item");
        TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "amount_without_tax");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<BigDecimal> QUANTITY = new TypedField<>(BigDecimal.class, "quantity");
        TypedField<String> SETTLEMENT_NO = new TypedField<>(String.class, "settlement_no");
        TypedField<String> SETTLEMENT_SEQ = new TypedField<>(String.class, "settlement_seq");
        TypedField<String> ORDER_DETAIL_ID = new TypedField<>(String.class, "order_detail_id");
        TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "tax_amount");
        TypedField<String> GR_NO = new TypedField<>(String.class, "gr_no");
        TypedField<String> GR_ITEM_NO = new TypedField<>(String.class, "gr_item_no");
        TypedField<String> ORG_TREE = new TypedField<>(String.class, "org_tree");
        /**
         * 对一关联关系 关联对象 miroBillDetails
         */
        TypedField<Long> BILL_DEATIL_OTM_ORDER_ID = new TypedField<>(Long.class, "billDeatilOtmOrder.id");
        /**
         * 对一关联关系 关联对象 miroResult
         */
        TypedField<Long> RESULT_OTM_ORDER_ID = new TypedField<>(Long.class, "resultOtmOrder.id");
    }
    public interface MiroNoCoopSalesbill {
        static Long id() {
            return 1554356931110375425L;
        }
        static String code() {
            return "miroNoCoopSalesbill";
        }
        TypedField<String> ORDER_NO = new TypedField<>(String.class, "order_no");
        TypedField<String> ORDER_ITEM = new TypedField<>(String.class, "order_item");
        TypedField<String> LARGE_CATEGORY_NAME = new TypedField<>(String.class, "large_category_name");
        TypedField<String> SALESBILL_ITEM_NO = new TypedField<>(String.class, "salesbill_item_no");
        TypedField<String> ITEM_NAME = new TypedField<>(String.class, "item_name");
        TypedField<String> ZERO_TAX = new TypedField<>(String.class, "zero_tax");
        TypedField<String> GOODS_TAX_NO = new TypedField<>(String.class, "goods_tax_no");
        TypedField<String> QUANTITY_UNIT = new TypedField<>(String.class, "quantity_unit");
        TypedField<String> TAX_PRE_CON = new TypedField<>(String.class, "tax_pre_con");
        TypedField<String> TAX_PRE = new TypedField<>(String.class, "tax_pre");
        TypedField<String> SELLER_NO = new TypedField<>(String.class, "seller_no");
        TypedField<String> SELLER_NAME = new TypedField<>(String.class, "seller_name");
        TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "purchaser_no");
        TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "purchaser_name");
        TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "seller_tax_no");
        TypedField<String> SELLER_ADDRESS = new TypedField<>(String.class, "seller_address");
        TypedField<String> SELLER_PHONE = new TypedField<>(String.class, "seller_phone");
        TypedField<String> SELLER_BANK = new TypedField<>(String.class, "seller_bank");
        TypedField<String> SELLER_BANK_ACCOUNT = new TypedField<>(String.class, "seller_bank_account");
        TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "purchaser_tax_no");
        TypedField<String> PURCHASER_ADDRESS = new TypedField<>(String.class, "purchaser_address");
        TypedField<String> PURCHASER_PHONE = new TypedField<>(String.class, "purchaser_phone");
        TypedField<String> PURCHASER_BANK = new TypedField<>(String.class, "purchaser_bank");
        TypedField<String> PURCHASER_BANK_ACCOUNT = new TypedField<>(String.class, "purchaser_bank_account");
        TypedField<String> SALESBILL_NO = new TypedField<>(String.class, "salesbill_no");
        TypedField<String> EXT1 = new TypedField<>(String.class, "ext1");
        TypedField<String> EXT2 = new TypedField<>(String.class, "ext2");
        TypedField<String> EXT3 = new TypedField<>(String.class, "ext3");
        TypedField<String> EXT5 = new TypedField<>(String.class, "ext5");
        TypedField<String> EXT6 = new TypedField<>(String.class, "ext6");
        TypedField<String> REMARK = new TypedField<>(String.class, "remark");
        TypedField<String> EXT7 = new TypedField<>(String.class, "ext7");
        TypedField<String> EXT8 = new TypedField<>(String.class, "ext8");
        TypedField<String> EXT9 = new TypedField<>(String.class, "ext9");
        TypedField<String> EXT10 = new TypedField<>(String.class, "ext10");
        TypedField<String> EXT10_DETAIL = new TypedField<>(String.class, "ext10_detail");
        TypedField<String> MEDIAN_CATEGORY_NAME = new TypedField<>(String.class, "median_category_name");
        TypedField<String> SMALL_CATEGORY_NAME = new TypedField<>(String.class, "small_category_name");
        TypedField<String> EXT4 = new TypedField<>(String.class, "ext4");
        TypedField<String> EXT4_DETAIL = new TypedField<>(String.class, "ext4_detail");
        TypedField<String> ITEM_NO = new TypedField<>(String.class, "item_no");
        TypedField<String> TAX_NO = new TypedField<>(String.class, "tax_no");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> NO_COOP_SALESBILL_STATUS = new TypedField<>(String.class, "no_coop_salesbill_status");
        TypedField<String> AMOUNT_WITHOUT_TAX = new TypedField<>(String.class, "amount_without_tax");
        TypedField<String> TAX_AMOUNT = new TypedField<>(String.class, "tax_amount");
        TypedField<String> AMOUNT_WITH_TAX = new TypedField<>(String.class, "amount_with_tax");
        TypedField<String> QUANTITY = new TypedField<>(String.class, "quantity");
        TypedField<String> UNIT_PRICE = new TypedField<>(String.class, "unit_price");
        TypedField<String> UNIT_PRICE_WITH_TAX = new TypedField<>(String.class, "unit_price_with_tax");
        TypedField<String> TAX_RATE = new TypedField<>(String.class, "tax_rate");
        TypedField<String> EXT17 = new TypedField<>(String.class, "ext17");
        TypedField<String> SETTLEMENT_FAIL = new TypedField<>(String.class, "settlement_fail");
        TypedField<String> PURCHASER_EMAIL = new TypedField<>(String.class, "purchaser_email");
        TypedField<String> SELLER_EMAIL = new TypedField<>(String.class, "seller_email");
        TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "invoice_type");
        TypedField<String> NO_COOP_SETTLE_PERIOD = new TypedField<>(String.class, "no_coop_settle_period");
        TypedField<String> SETTLEMENT_NO = new TypedField<>(String.class, "settlement_no");
        TypedField<LocalDateTime> EXT12 = new TypedField<>(LocalDateTime.class, "ext12");
        TypedField<String> EXT11 = new TypedField<>(String.class, "ext11");
        TypedField<String> PRICE_METHOD = new TypedField<>(String.class, "price_method");
        TypedField<String> EXT18 = new TypedField<>(String.class, "ext18");
        TypedField<String> ITEM_TYPE_CODE = new TypedField<>(String.class, "item_type_code");
        TypedField<String> EXT21 = new TypedField<>(String.class, "ext21");
        TypedField<String> BUYFORCASH = new TypedField<>(String.class, "buyForCash");
        TypedField<String> EXT23 = new TypedField<>(String.class, "ext23");
        TypedField<String> ORG_TREE = new TypedField<>(String.class, "org_tree");
        /**
         * 对一关联关系 关联对象 miroNoCoopSettlement
         */
        TypedField<Long> SETTLEMENT_TO_SALESBILLS_ID = new TypedField<>(Long.class, "settlementToSalesbills.id");
    }
    public interface MiroNoCoopSettlement {
        static Long id() {
            return 1554369358631190530L;
        }
        static String code() {
            return "miroNoCoopSettlement";
        }
        TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "amount_with_tax");
        TypedField<String> SELLER_NO = new TypedField<>(String.class, "seller_no");
        TypedField<String> SELLER_NAME = new TypedField<>(String.class, "seller_name");
        TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "purchaser_no");
        TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "purchaser_name");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> EMAIL_RECORD = new TypedField<>(String.class, "email_record");
        TypedField<String> MESSAGE_RECORD = new TypedField<>(String.class, "message_record");
        TypedField<String> SETTLEMENT_NO = new TypedField<>(String.class, "settlement_no");
        TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "amount_without_tax");
        TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "tax_amount");
        TypedField<String> RELATE_ORDER_NO = new TypedField<>(String.class, "relate_order_no");
        TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "purchaser_tax_no");
        TypedField<String> PURCHASER_ADDRESS = new TypedField<>(String.class, "purchaser_address");
        TypedField<String> PURCHASER_PHONE = new TypedField<>(String.class, "purchaser_phone");
        TypedField<String> PURCHASER_EMAIL = new TypedField<>(String.class, "purchaser_email");
        TypedField<String> PURCHASER_BANK = new TypedField<>(String.class, "purchaser_bank");
        TypedField<String> PURCHASER_BANK_ACCOUNT = new TypedField<>(String.class, "purchaser_bank_account");
        TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "seller_tax_no");
        TypedField<String> SELLER_ADDRESS = new TypedField<>(String.class, "seller_address");
        TypedField<String> SELLER_PHONE = new TypedField<>(String.class, "seller_phone");
        TypedField<String> SELLER_EMAIL = new TypedField<>(String.class, "seller_email");
        TypedField<String> SELLER_BANK = new TypedField<>(String.class, "seller_bank");
        TypedField<String> SELLER_BANK_ACCOUNT = new TypedField<>(String.class, "seller_bank_account");
        TypedField<String> UPLOAD_STATUS = new TypedField<>(String.class, "upload_status");
        TypedField<String> BATCH_NO = new TypedField<>(String.class, "batch_no");
        TypedField<String> NO_COOP_SETTLEMENT_STATUS = new TypedField<>(String.class, "no_coop_settlement_status");
        TypedField<String> SETTLEMENT_FRONT = new TypedField<>(String.class, "settlement_front");
        TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "invoice_type");
        TypedField<Long> SMS_SEND_COUNT = new TypedField<>(Long.class, "sms_send_count");
        TypedField<String> EXT12 = new TypedField<>(String.class, "ext12");
        TypedField<String> EXT18 = new TypedField<>(String.class, "ext18");
        TypedField<String> EXT20 = new TypedField<>(String.class, "ext20");
        TypedField<String> BUYFORCASH = new TypedField<>(String.class, "buyForCash");
        TypedField<String> ORG_TREE = new TypedField<>(String.class, "org_tree");
    }
    public interface MiroNoCoopSettlementDetail {
        static Long id() {
            return 1554712687647133697L;
        }
        static String code() {
            return "miroNoCoopSettlementDetail";
        }
        TypedField<String> ORDER_NO = new TypedField<>(String.class, "order_no");
        TypedField<String> ORDER_ITEM = new TypedField<>(String.class, "order_item");
        TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "amount_without_tax");
        TypedField<BigDecimal> QUANTITY = new TypedField<>(BigDecimal.class, "quantity");
        TypedField<String> SETTLEMENT_NO = new TypedField<>(String.class, "settlement_no");
        TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "tax_amount");
        TypedField<String> LARGE_CATEGORY_NAME = new TypedField<>(String.class, "large_category_name");
        TypedField<String> SALESBILL_ITEM_NO = new TypedField<>(String.class, "salesbill_item_no");
        TypedField<String> ITEM_NAME = new TypedField<>(String.class, "item_name");
        TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "amount_with_tax");
        TypedField<String> ZERO_TAX = new TypedField<>(String.class, "zero_tax");
        TypedField<String> GOODS_TAX_NO = new TypedField<>(String.class, "goods_tax_no");
        TypedField<String> QUANTITY_UNIT = new TypedField<>(String.class, "quantity_unit");
        TypedField<String> TAX_PRE_CON = new TypedField<>(String.class, "tax_pre_con");
        TypedField<String> TAX_PRE = new TypedField<>(String.class, "tax_pre");
        TypedField<String> SELLER_NO = new TypedField<>(String.class, "seller_no");
        TypedField<String> SELLER_NAME = new TypedField<>(String.class, "seller_name");
        TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "purchaser_no");
        TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "purchaser_name");
        TypedField<String> EXT1 = new TypedField<>(String.class, "ext1");
        TypedField<String> EXT2 = new TypedField<>(String.class, "ext2");
        TypedField<String> EXT3 = new TypedField<>(String.class, "ext3");
        TypedField<String> EXT5 = new TypedField<>(String.class, "ext5");
        TypedField<String> EXT6 = new TypedField<>(String.class, "ext6");
        TypedField<String> REMARK = new TypedField<>(String.class, "remark");
        TypedField<String> EXT7 = new TypedField<>(String.class, "ext7");
        TypedField<String> EXT8 = new TypedField<>(String.class, "ext8");
        TypedField<String> EXT9 = new TypedField<>(String.class, "ext9");
        TypedField<String> EXT10 = new TypedField<>(String.class, "ext10");
        TypedField<String> EXT10_DETAIL = new TypedField<>(String.class, "ext10_detail");
        TypedField<String> MEDIAN_CATEGORY_NAME = new TypedField<>(String.class, "median_category_name");
        TypedField<String> SMALL_CATEGORY_NAME = new TypedField<>(String.class, "small_category_name");
        TypedField<String> EXT4 = new TypedField<>(String.class, "ext4");
        TypedField<String> EXT4_DETAIL = new TypedField<>(String.class, "ext4_detail");
        TypedField<String> ITEM_NO = new TypedField<>(String.class, "item_no");
        TypedField<String> TAX_NO = new TypedField<>(String.class, "tax_no");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> UNIT_PRICE = new TypedField<>(String.class, "unit_price");
        TypedField<String> UNIT_PRICE_WITH_TAX = new TypedField<>(String.class, "unit_price_with_tax");
        TypedField<String> TAX_RATE = new TypedField<>(String.class, "tax_rate");
        TypedField<String> EXT17 = new TypedField<>(String.class, "ext17");
        TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "invoice_type");
        TypedField<String> EXT11 = new TypedField<>(String.class, "ext11");
        TypedField<String> PRICE_METHOD = new TypedField<>(String.class, "price_method");
        TypedField<String> EXT12 = new TypedField<>(String.class, "ext12");
        TypedField<String> ITEM_TYPE_CODE = new TypedField<>(String.class, "item_type_code");
        TypedField<String> EXT23 = new TypedField<>(String.class, "ext23");
        TypedField<String> ORG_TREE = new TypedField<>(String.class, "org_tree");
        /**
         * 对一关联关系 关联对象 miroNoCoopSettlement
         */
        TypedField<Long> SETTLEMENT_TO_DETAILS_ID = new TypedField<>(Long.class, "settlementToDetails.id");
    }
    public interface DiscountSellerConfig {
        static Long id() {
            return 1574288411146915841L;
        }
        static String code() {
            return "discountSellerConfig";
        }
        TypedField<String> SELLER_NO = new TypedField<>(String.class, "seller_no");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> SELLER_NAME = new TypedField<>(String.class, "seller_name");
        TypedField<String> STATUS = new TypedField<>(String.class, "status");
        TypedField<String> UPDATE_RECORD = new TypedField<>(String.class, "update_record");
        TypedField<Long> DISCOUNT_RATE = new TypedField<>(Long.class, "discount_rate");
        TypedField<String> DISCOUNT_SELECT_FLAG = new TypedField<>(String.class, "discount_select_flag");
        TypedField<Long> DISCOUNT_MAX_PROPORTION = new TypedField<>(Long.class, "discount_max_proportion");
        TypedField<String> ORG_TREE = new TypedField<>(String.class, "org_tree");
    }
    public interface ItemMappingConfig {
        static Long id() {
            return 1912738605344272385L;
        }
        static String code() {
            return "itemMappingConfig";
        }
        TypedField<String> ITEMCODE = new TypedField<>(String.class, "itemCode");
        TypedField<String> ITEMSERVICEORNAME = new TypedField<>(String.class, "itemServiceOrName");
        TypedField<String> ITEMNAME = new TypedField<>(String.class, "itemName");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<String> ORG_TREE = new TypedField<>(String.class, "org_tree");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }
    public interface BizOrder {
        static Long id() {
            return 1919944037922025473L;
        }
        static String code() {
            return "bizOrder";
        }
        TypedField<String> BIZORDERTYPE = new TypedField<>(String.class, "bizOrderType");
        TypedField<String> RAWDATA = new TypedField<>(String.class, "rawData");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<String> ORG_TREE = new TypedField<>(String.class, "org_tree");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> BIZORDERSTATUS = new TypedField<>(String.class, "bizOrderStatus");
        TypedField<String> BIZORDERNO = new TypedField<>(String.class, "bizOrderNo");
        TypedField<String> COOP = new TypedField<>(String.class, "coop");
        TypedField<String> REMARK = new TypedField<>(String.class, "remark");
        TypedField<String> PURCHASERTAXNO = new TypedField<>(String.class, "purchaserTaxNo");
        TypedField<String> PURCHASERNAME = new TypedField<>(String.class, "purchaserName");
        TypedField<String> SELLERTAXNO = new TypedField<>(String.class, "sellerTaxNo");
        TypedField<String> SELLERNAME = new TypedField<>(String.class, "sellerName");
        TypedField<String> PERIOD = new TypedField<>(String.class, "period");
    }
}
