package com.xforceplus.compass.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * biz_order_type
 * </p>
 *
 * @author ultraman
 * @since 2025-10-28
 */
public enum BizOrderType {

    GR("GR", "收货业务单"),
    RB("RB", "返利业务单");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    BizOrderType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BizOrderType fromCode(String code){
        switch(code) {
            case "GR":
                return GR;
            case "RB":
                return RB;
            default:
                return null;
        }
    }
}
