package com.xforceplus.compass.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * year_bill_status
 * </p>
 *
 * @author ultraman
 * @since 2025-10-28
 */
public enum YearBillStatus {

    _0("0", "初始化"),
    _1("1", "计算中"),
    _2("2", "已发布"),
    _5("5", "已取消"),
    _6("6", "已确认"),
    _7("7", "异常");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    YearBillStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static YearBillStatus fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            case "5":
                return _5;
            case "6":
                return _6;
            case "7":
                return _7;
            default:
                return null;
        }
    }
}
