package com.xforceplus.compass.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 账单发票表
 * </p>
 *
 * @author ultraman
 * @since 2022-05-30
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class BillInvoice implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 账单ID
   */
  private Long billId;

  /**
   * 账单编号
   */
  private String billNo;

  /**
   * 发票号码
   */
  private String invoiceNo;

  /**
   * 发票代码
   */
  private String invoiceCode;

  /**
   * 发票类型
   */
  private String invoiceType;

  /**
   * 开票日期
   */
  private String paperDrewDate;

  /**
   * 发票状态
   */
  private String status;

  /**
   * 红冲状态
   */
  private String redFlag;

  /**
   * 含税金额
   */
  private BigDecimal amountWithTax;

  /**
   * 税额
   */
  private BigDecimal taxAmount;

  /**
   * 价税合计
   */
  private BigDecimal totalAmountTaxNum;

  /**
   * 结算模式
   */
  private String settlementMode;

  /**
   * 扫描状态
   */
  private String scanStatus;

  /**
   * 发票扫描时间
   */
  private String scanTime;

  /**
   * 认证状态
   */
  private String authStatus;

  /**
   * 认证时间
   */
  private String authTime;

  /**
   * 红蓝标识
   */
  private String invoiceColor;

  /**
   * 返利总额（不含税）
   */
  private BigDecimal rebateWithoutTax;

  /**
   * 返利总额（含税）
   */
  private BigDecimal rebateWithTax;

  /**
   * 返利总税额
   */
  private BigDecimal rebateAmount;

  /**
   * 结算期间
   */
  private String settlementCycle;

  /**
   * id
   */
  private Long id;

  /**
   * 租户id
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 红字信息编码
   */
  private String redNotificationNo;

  /**
   * 不含税金额
   */
  private BigDecimal amountWithoutTax;

  /**
   * 项目地点
   */
  private String projectAddr;

  /**
   * 红冲时间
   */
  private String redTime;

  /**
   * 返利金额
   */
  private BigDecimal totalRebate;

  /**
   * 发票主信息json
   */
  private String invoice;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("bill_id", billId);
      map.put("bill_no", billNo);
      map.put("invoice_no", invoiceNo);
      map.put("invoice_code", invoiceCode);
      map.put("invoice_type", invoiceType);
      map.put("paper_drew_date", paperDrewDate);
      map.put("status", status);
      map.put("red_flag", redFlag);
      map.put("amount_with_tax", amountWithTax);
      map.put("tax_amount", taxAmount);
      map.put("total_amount_tax_num", totalAmountTaxNum);
      map.put("settlement_mode", settlementMode);
      map.put("scan_status", scanStatus);
      map.put("scan_time", scanTime);
      map.put("auth_status", authStatus);
      map.put("auth_time", authTime);
      map.put("invoice_color", invoiceColor);
      map.put("rebate_without_tax", rebateWithoutTax);
      map.put("rebate_with_tax", rebateWithTax);
      map.put("rebate_amount", rebateAmount);
      map.put("settlement_cycle", settlementCycle);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("red_notification_no", redNotificationNo);
      map.put("amount_without_tax", amountWithoutTax);
      map.put("project_addr", projectAddr);
      map.put("red_time", redTime);
      map.put("total_rebate", totalRebate);
      map.put("invoice", invoice);
      return map;
  }

  public static BillInvoice fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    BillInvoice entity = new BillInvoice();
    if(map.containsKey("bill_id")) {
      Object obj = map.get("bill_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setBillId((Long)obj);
        } else if(obj instanceof String) {
          entity.setBillId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setBillId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("bill_no")) {
      Object obj = map.get("bill_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBillNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_no")) {
      Object obj = map.get("invoice_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_code")) {
      Object obj = map.get("invoice_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_type")) {
      Object obj = map.get("invoice_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paper_drew_date")) {
      Object obj = map.get("paper_drew_date");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaperDrewDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("red_flag")) {
      Object obj = map.get("red_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRedFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amount_with_tax")) {
      Object obj = map.get("amount_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("tax_amount")) {
      Object obj = map.get("tax_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("total_amount_tax_num")) {
      Object obj = map.get("total_amount_tax_num");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTotalAmountTaxNum((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTotalAmountTaxNum(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTotalAmountTaxNum(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setTotalAmountTaxNum(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTotalAmountTaxNum(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("settlement_mode")) {
      Object obj = map.get("settlement_mode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSettlementMode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("scan_status")) {
      Object obj = map.get("scan_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setScanStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("scan_time")) {
      Object obj = map.get("scan_time");
      if(obj != null) {
        if(obj instanceof String){
          entity.setScanTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("auth_status")) {
      Object obj = map.get("auth_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAuthStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("auth_time")) {
      Object obj = map.get("auth_time");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAuthTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_color")) {
      Object obj = map.get("invoice_color");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceColor((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("rebate_without_tax")) {
      Object obj = map.get("rebate_without_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setRebateWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setRebateWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setRebateWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setRebateWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setRebateWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("rebate_with_tax")) {
      Object obj = map.get("rebate_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setRebateWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setRebateWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setRebateWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setRebateWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setRebateWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("rebate_amount")) {
      Object obj = map.get("rebate_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setRebateAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setRebateAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setRebateAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setRebateAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setRebateAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("settlement_cycle")) {
      Object obj = map.get("settlement_cycle");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSettlementCycle((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("red_notification_no")) {
      Object obj = map.get("red_notification_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRedNotificationNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amount_without_tax")) {
      Object obj = map.get("amount_without_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("project_addr")) {
      Object obj = map.get("project_addr");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProjectAddr((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("red_time")) {
      Object obj = map.get("red_time");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRedTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("total_rebate")) {
      Object obj = map.get("total_rebate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTotalRebate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTotalRebate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTotalRebate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setTotalRebate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTotalRebate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("invoice")) {
      Object obj = map.get("invoice");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoice((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
