package com.xforceplus.compass.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.compass.entity.YearBill;
import com.xforceplus.compass.service.IYearBillService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 年度账单概要前端控制器
 *
 * @author ultraman
 * @date 2022-08-08
 */
@RestController
public class YearBillController {

  @Autowired
  private IYearBillService yearBillServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param yearBill 年度账单概要
   * @return
   */
  @GetMapping("/yearbills" )
  public XfR getYearBills(XfPage page, YearBill yearBill) {
    return XfR.ok(yearBillServiceImpl.page(page, Wrappers.query(yearBill)));
  }

  /**
   * 通过id查询年度账单概要
   * @param  id
   * @return XfR
   */
  @GetMapping("/yearbills/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(yearBillServiceImpl.getById(id));
  }

  /**
   * 新增年度账单概要
   * @param yearBill 年度账单概要
   * @return XfR
   */
  @PostMapping("/yearbills")
  public XfR save(@RequestBody YearBill yearBill) {
     return XfR.ok(yearBillServiceImpl.save(yearBill));
  }

  /**
   * 修改-传入修改后的全部数据年度账单概要
   * @param yearBill 年度账单概要
   * @return XfR
   */
  @PutMapping("/yearbills/{id}")
  public XfR putUpdate(@RequestBody YearBill yearBill,@PathVariable Long id) {
      yearBill.setId(id);
      return XfR.ok(yearBillServiceImpl.updateById(yearBill));
  }

  /**
   * 修改-传入修改的数据年度账单概要
   * @param yearBill 年度账单概要
   * @return XfR
   */
  @PatchMapping("/yearbills/{id}")
  public XfR patchUpdate(@RequestBody YearBill yearBill,@PathVariable Long id) {
      YearBill upyearBill = yearBillServiceImpl.getById(id);
      if(upyearBill != null){
        upyearBill = ObjectCopyUtils.copyProperties(yearBill,upyearBill,true);
      }
      return XfR.ok(yearBillServiceImpl.updateById(upyearBill));
  }

  /**
   * 通过id删除年度账单概要
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/yearbills/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(yearBillServiceImpl.removeById(id));
  }

  @PostMapping("/yearbills/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "year_bill");
     params.put("request", condition);

     return XfR.ok(yearBillServiceImpl.querys(params));
  }

}
