package com.xforceplus.compass.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.compass.entity.YearBillMain;
import com.xforceplus.compass.service.IYearBillMainService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-06-06
 */
@RestController
public class YearBillMainController {

  @Autowired
  private IYearBillMainService yearBillMainServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param yearBillMain ${table.comment}
   * @return
   */
  @GetMapping("/yearbillmains" )
  public XfR getYearBillMains(XfPage page, YearBillMain yearBillMain) {
    return XfR.ok(yearBillMainServiceImpl.page(page, Wrappers.query(yearBillMain)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/yearbillmains/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(yearBillMainServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param yearBillMain ${table.comment}
   * @return XfR
   */
  @PostMapping("/yearbillmains")
  public XfR save(@RequestBody YearBillMain yearBillMain) {
     return XfR.ok(yearBillMainServiceImpl.save(yearBillMain));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param yearBillMain ${table.comment}
   * @return XfR
   */
  @PutMapping("/yearbillmains/{id}")
  public XfR putUpdate(@RequestBody YearBillMain yearBillMain,@PathVariable Long id) {
      yearBillMain.setId(id);
      return XfR.ok(yearBillMainServiceImpl.updateById(yearBillMain));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param yearBillMain ${table.comment}
   * @return XfR
   */
  @PatchMapping("/yearbillmains/{id}")
  public XfR patchUpdate(@RequestBody YearBillMain yearBillMain,@PathVariable Long id) {
      YearBillMain upyearBillMain = yearBillMainServiceImpl.getById(id);
      if(upyearBillMain != null){
        upyearBillMain = ObjectCopyUtils.copyProperties(yearBillMain,upyearBillMain,true);
      }
      return XfR.ok(yearBillMainServiceImpl.updateById(upyearBillMain));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/yearbillmains/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(yearBillMainServiceImpl.removeById(id));
  }

  @PostMapping("/yearbillmains/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "year_bill_main");
     params.put("request", condition);

     return XfR.ok(yearBillMainServiceImpl.querys(params));
  }

}
