package com.xforceplus.dajiang.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.dajiang.entity.CustomerExportContract;
import com.xforceplus.dajiang.service.ICustomerExportContractService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-08-16
 */
@RestController
public class CustomerExportContractController {

  @Autowired
  private ICustomerExportContractService customerExportContractServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param customerExportContract ${table.comment}
   * @return
   */
  @GetMapping("/customerexportcontracts" )
  public XfR getCustomerExportContracts(XfPage page, CustomerExportContract customerExportContract) {
    return XfR.ok(customerExportContractServiceImpl.page(page, Wrappers.query(customerExportContract)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/customerexportcontracts/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(customerExportContractServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param customerExportContract ${table.comment}
   * @return XfR
   */
  @PostMapping("/customerexportcontracts")
  public XfR save(@RequestBody CustomerExportContract customerExportContract) {
     return XfR.ok(customerExportContractServiceImpl.save(customerExportContract));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param customerExportContract ${table.comment}
   * @return XfR
   */
  @PutMapping("/customerexportcontracts/{id}")
  public XfR putUpdate(@RequestBody CustomerExportContract customerExportContract,@PathVariable Long id) {
      customerExportContract.setId(id);
      return XfR.ok(customerExportContractServiceImpl.updateById(customerExportContract));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param customerExportContract ${table.comment}
   * @return XfR
   */
  @PatchMapping("/customerexportcontracts/{id}")
  public XfR patchUpdate(@RequestBody CustomerExportContract customerExportContract,@PathVariable Long id) {
      CustomerExportContract upcustomerExportContract = customerExportContractServiceImpl.getById(id);
      if(upcustomerExportContract != null){
        upcustomerExportContract = ObjectCopyUtils.copyProperties(customerExportContract,upcustomerExportContract,true);
      }
      return XfR.ok(customerExportContractServiceImpl.updateById(upcustomerExportContract));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/customerexportcontracts/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(customerExportContractServiceImpl.removeById(id));
  }

  @PostMapping("/customerexportcontracts/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "customer_export_contract");
     params.put("request", condition);

     return XfR.ok(customerExportContractServiceImpl.querys(params));
  }

}
