package com.xforceplus.dajiang.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.dajiang.entity.CustomerExportContractLine;
import com.xforceplus.dajiang.service.ICustomerExportContractLineService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-08-16
 */
@RestController
public class CustomerExportContractLineController {

  @Autowired
  private ICustomerExportContractLineService customerExportContractLineServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param customerExportContractLine ${table.comment}
   * @return
   */
  @GetMapping("/customerexportcontractlines" )
  public XfR getCustomerExportContractLines(XfPage page, CustomerExportContractLine customerExportContractLine) {
    return XfR.ok(customerExportContractLineServiceImpl.page(page, Wrappers.query(customerExportContractLine)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/customerexportcontractlines/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(customerExportContractLineServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param customerExportContractLine ${table.comment}
   * @return XfR
   */
  @PostMapping("/customerexportcontractlines")
  public XfR save(@RequestBody CustomerExportContractLine customerExportContractLine) {
     return XfR.ok(customerExportContractLineServiceImpl.save(customerExportContractLine));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param customerExportContractLine ${table.comment}
   * @return XfR
   */
  @PutMapping("/customerexportcontractlines/{id}")
  public XfR putUpdate(@RequestBody CustomerExportContractLine customerExportContractLine,@PathVariable Long id) {
      customerExportContractLine.setId(id);
      return XfR.ok(customerExportContractLineServiceImpl.updateById(customerExportContractLine));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param customerExportContractLine ${table.comment}
   * @return XfR
   */
  @PatchMapping("/customerexportcontractlines/{id}")
  public XfR patchUpdate(@RequestBody CustomerExportContractLine customerExportContractLine,@PathVariable Long id) {
      CustomerExportContractLine upcustomerExportContractLine = customerExportContractLineServiceImpl.getById(id);
      if(upcustomerExportContractLine != null){
        upcustomerExportContractLine = ObjectCopyUtils.copyProperties(customerExportContractLine,upcustomerExportContractLine,true);
      }
      return XfR.ok(customerExportContractLineServiceImpl.updateById(upcustomerExportContractLine));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/customerexportcontractlines/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(customerExportContractLineServiceImpl.removeById(id));
  }

  @PostMapping("/customerexportcontractlines/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "customer_export_contract_line");
     params.put("request", condition);

     return XfR.ok(customerExportContractLineServiceImpl.querys(params));
  }

}
