package com.xforceplus.dajiang.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.dajiang.entity.CustomsExportDeclaration;
import com.xforceplus.dajiang.service.ICustomsExportDeclarationService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-08-16
 */
@RestController
public class CustomsExportDeclarationController {

  @Autowired
  private ICustomsExportDeclarationService customsExportDeclarationServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param customsExportDeclaration ${table.comment}
   * @return
   */
  @GetMapping("/customsexportdeclarations" )
  public XfR getCustomsExportDeclarations(XfPage page, CustomsExportDeclaration customsExportDeclaration) {
    return XfR.ok(customsExportDeclarationServiceImpl.page(page, Wrappers.query(customsExportDeclaration)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/customsexportdeclarations/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(customsExportDeclarationServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param customsExportDeclaration ${table.comment}
   * @return XfR
   */
  @PostMapping("/customsexportdeclarations")
  public XfR save(@RequestBody CustomsExportDeclaration customsExportDeclaration) {
     return XfR.ok(customsExportDeclarationServiceImpl.save(customsExportDeclaration));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param customsExportDeclaration ${table.comment}
   * @return XfR
   */
  @PutMapping("/customsexportdeclarations/{id}")
  public XfR putUpdate(@RequestBody CustomsExportDeclaration customsExportDeclaration,@PathVariable Long id) {
      customsExportDeclaration.setId(id);
      return XfR.ok(customsExportDeclarationServiceImpl.updateById(customsExportDeclaration));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param customsExportDeclaration ${table.comment}
   * @return XfR
   */
  @PatchMapping("/customsexportdeclarations/{id}")
  public XfR patchUpdate(@RequestBody CustomsExportDeclaration customsExportDeclaration,@PathVariable Long id) {
      CustomsExportDeclaration upcustomsExportDeclaration = customsExportDeclarationServiceImpl.getById(id);
      if(upcustomsExportDeclaration != null){
        upcustomsExportDeclaration = ObjectCopyUtils.copyProperties(customsExportDeclaration,upcustomsExportDeclaration,true);
      }
      return XfR.ok(customsExportDeclarationServiceImpl.updateById(upcustomsExportDeclaration));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/customsexportdeclarations/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(customsExportDeclarationServiceImpl.removeById(id));
  }

  @PostMapping("/customsexportdeclarations/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "customs_export_declaration");
     params.put("request", condition);

     return XfR.ok(customsExportDeclarationServiceImpl.querys(params));
  }

}
