package com.xforceplus.dajiang.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.dajiang.entity.CustomsExportDeclarationLine;
import com.xforceplus.dajiang.service.ICustomsExportDeclarationLineService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-08-16
 */
@RestController
public class CustomsExportDeclarationLineController {

  @Autowired
  private ICustomsExportDeclarationLineService customsExportDeclarationLineServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param customsExportDeclarationLine ${table.comment}
   * @return
   */
  @GetMapping("/customsexportdeclarationlines" )
  public XfR getCustomsExportDeclarationLines(XfPage page, CustomsExportDeclarationLine customsExportDeclarationLine) {
    return XfR.ok(customsExportDeclarationLineServiceImpl.page(page, Wrappers.query(customsExportDeclarationLine)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/customsexportdeclarationlines/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(customsExportDeclarationLineServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param customsExportDeclarationLine ${table.comment}
   * @return XfR
   */
  @PostMapping("/customsexportdeclarationlines")
  public XfR save(@RequestBody CustomsExportDeclarationLine customsExportDeclarationLine) {
     return XfR.ok(customsExportDeclarationLineServiceImpl.save(customsExportDeclarationLine));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param customsExportDeclarationLine ${table.comment}
   * @return XfR
   */
  @PutMapping("/customsexportdeclarationlines/{id}")
  public XfR putUpdate(@RequestBody CustomsExportDeclarationLine customsExportDeclarationLine,@PathVariable Long id) {
      customsExportDeclarationLine.setId(id);
      return XfR.ok(customsExportDeclarationLineServiceImpl.updateById(customsExportDeclarationLine));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param customsExportDeclarationLine ${table.comment}
   * @return XfR
   */
  @PatchMapping("/customsexportdeclarationlines/{id}")
  public XfR patchUpdate(@RequestBody CustomsExportDeclarationLine customsExportDeclarationLine,@PathVariable Long id) {
      CustomsExportDeclarationLine upcustomsExportDeclarationLine = customsExportDeclarationLineServiceImpl.getById(id);
      if(upcustomsExportDeclarationLine != null){
        upcustomsExportDeclarationLine = ObjectCopyUtils.copyProperties(customsExportDeclarationLine,upcustomsExportDeclarationLine,true);
      }
      return XfR.ok(customsExportDeclarationLineServiceImpl.updateById(upcustomsExportDeclarationLine));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/customsexportdeclarationlines/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(customsExportDeclarationLineServiceImpl.removeById(id));
  }

  @PostMapping("/customsexportdeclarationlines/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "customs_export_declaration_line");
     params.put("request", condition);

     return XfR.ok(customsExportDeclarationLineServiceImpl.querys(params));
  }

}
