package com.xforceplus.dajiang.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.dajiang.entity.ExchangeRate;
import com.xforceplus.dajiang.service.IExchangeRateService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-08-16
 */
@RestController
public class ExchangeRateController {

  @Autowired
  private IExchangeRateService exchangeRateServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param exchangeRate ${table.comment}
   * @return
   */
  @GetMapping("/exchangerates" )
  public XfR getExchangeRates(XfPage page, ExchangeRate exchangeRate) {
    return XfR.ok(exchangeRateServiceImpl.page(page, Wrappers.query(exchangeRate)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/exchangerates/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(exchangeRateServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param exchangeRate ${table.comment}
   * @return XfR
   */
  @PostMapping("/exchangerates")
  public XfR save(@RequestBody ExchangeRate exchangeRate) {
     return XfR.ok(exchangeRateServiceImpl.save(exchangeRate));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param exchangeRate ${table.comment}
   * @return XfR
   */
  @PutMapping("/exchangerates/{id}")
  public XfR putUpdate(@RequestBody ExchangeRate exchangeRate,@PathVariable Long id) {
      exchangeRate.setId(id);
      return XfR.ok(exchangeRateServiceImpl.updateById(exchangeRate));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param exchangeRate ${table.comment}
   * @return XfR
   */
  @PatchMapping("/exchangerates/{id}")
  public XfR patchUpdate(@RequestBody ExchangeRate exchangeRate,@PathVariable Long id) {
      ExchangeRate upexchangeRate = exchangeRateServiceImpl.getById(id);
      if(upexchangeRate != null){
        upexchangeRate = ObjectCopyUtils.copyProperties(exchangeRate,upexchangeRate,true);
      }
      return XfR.ok(exchangeRateServiceImpl.updateById(upexchangeRate));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/exchangerates/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(exchangeRateServiceImpl.removeById(id));
  }

  @PostMapping("/exchangerates/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "exchange_rate");
     params.put("request", condition);

     return XfR.ok(exchangeRateServiceImpl.querys(params));
  }

}
