package com.xforceplus.dajiang.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.dajiang.entity.LetterPaymentCollection;
import com.xforceplus.dajiang.service.ILetterPaymentCollectionService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-08-16
 */
@RestController
public class LetterPaymentCollectionController {

  @Autowired
  private ILetterPaymentCollectionService letterPaymentCollectionServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param letterPaymentCollection ${table.comment}
   * @return
   */
  @GetMapping("/letterpaymentcollections" )
  public XfR getLetterPaymentCollections(XfPage page, LetterPaymentCollection letterPaymentCollection) {
    return XfR.ok(letterPaymentCollectionServiceImpl.page(page, Wrappers.query(letterPaymentCollection)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/letterpaymentcollections/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(letterPaymentCollectionServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param letterPaymentCollection ${table.comment}
   * @return XfR
   */
  @PostMapping("/letterpaymentcollections")
  public XfR save(@RequestBody LetterPaymentCollection letterPaymentCollection) {
     return XfR.ok(letterPaymentCollectionServiceImpl.save(letterPaymentCollection));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param letterPaymentCollection ${table.comment}
   * @return XfR
   */
  @PutMapping("/letterpaymentcollections/{id}")
  public XfR putUpdate(@RequestBody LetterPaymentCollection letterPaymentCollection,@PathVariable Long id) {
      letterPaymentCollection.setId(id);
      return XfR.ok(letterPaymentCollectionServiceImpl.updateById(letterPaymentCollection));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param letterPaymentCollection ${table.comment}
   * @return XfR
   */
  @PatchMapping("/letterpaymentcollections/{id}")
  public XfR patchUpdate(@RequestBody LetterPaymentCollection letterPaymentCollection,@PathVariable Long id) {
      LetterPaymentCollection upletterPaymentCollection = letterPaymentCollectionServiceImpl.getById(id);
      if(upletterPaymentCollection != null){
        upletterPaymentCollection = ObjectCopyUtils.copyProperties(letterPaymentCollection,upletterPaymentCollection,true);
      }
      return XfR.ok(letterPaymentCollectionServiceImpl.updateById(upletterPaymentCollection));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/letterpaymentcollections/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(letterPaymentCollectionServiceImpl.removeById(id));
  }

  @PostMapping("/letterpaymentcollections/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "letter_payment_collection");
     params.put("request", condition);

     return XfR.ok(letterPaymentCollectionServiceImpl.querys(params));
  }

}
