package com.xforceplus.dajiang.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.dajiang.entity.OrderBillLine;
import com.xforceplus.dajiang.service.IOrderBillLineService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-08-16
 */
@RestController
public class OrderBillLineController {

  @Autowired
  private IOrderBillLineService orderBillLineServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param orderBillLine ${table.comment}
   * @return
   */
  @GetMapping("/orderbilllines" )
  public XfR getOrderBillLines(XfPage page, OrderBillLine orderBillLine) {
    return XfR.ok(orderBillLineServiceImpl.page(page, Wrappers.query(orderBillLine)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/orderbilllines/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(orderBillLineServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param orderBillLine ${table.comment}
   * @return XfR
   */
  @PostMapping("/orderbilllines")
  public XfR save(@RequestBody OrderBillLine orderBillLine) {
     return XfR.ok(orderBillLineServiceImpl.save(orderBillLine));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param orderBillLine ${table.comment}
   * @return XfR
   */
  @PutMapping("/orderbilllines/{id}")
  public XfR putUpdate(@RequestBody OrderBillLine orderBillLine,@PathVariable Long id) {
      orderBillLine.setId(id);
      return XfR.ok(orderBillLineServiceImpl.updateById(orderBillLine));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param orderBillLine ${table.comment}
   * @return XfR
   */
  @PatchMapping("/orderbilllines/{id}")
  public XfR patchUpdate(@RequestBody OrderBillLine orderBillLine,@PathVariable Long id) {
      OrderBillLine uporderBillLine = orderBillLineServiceImpl.getById(id);
      if(uporderBillLine != null){
        uporderBillLine = ObjectCopyUtils.copyProperties(orderBillLine,uporderBillLine,true);
      }
      return XfR.ok(orderBillLineServiceImpl.updateById(uporderBillLine));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/orderbilllines/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(orderBillLineServiceImpl.removeById(id));
  }

  @PostMapping("/orderbilllines/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "order_bill_line");
     params.put("request", condition);

     return XfR.ok(orderBillLineServiceImpl.querys(params));
  }

}
