package com.xforceplus.dajiang.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.dajiang.entity.TaxCodeMaintain;
import com.xforceplus.dajiang.service.ITaxCodeMaintainService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-08-16
 */
@RestController
public class TaxCodeMaintainController {

  @Autowired
  private ITaxCodeMaintainService taxCodeMaintainServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param taxCodeMaintain ${table.comment}
   * @return
   */
  @GetMapping("/taxcodemaintains" )
  public XfR getTaxCodeMaintains(XfPage page, TaxCodeMaintain taxCodeMaintain) {
    return XfR.ok(taxCodeMaintainServiceImpl.page(page, Wrappers.query(taxCodeMaintain)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/taxcodemaintains/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(taxCodeMaintainServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param taxCodeMaintain ${table.comment}
   * @return XfR
   */
  @PostMapping("/taxcodemaintains")
  public XfR save(@RequestBody TaxCodeMaintain taxCodeMaintain) {
     return XfR.ok(taxCodeMaintainServiceImpl.save(taxCodeMaintain));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param taxCodeMaintain ${table.comment}
   * @return XfR
   */
  @PutMapping("/taxcodemaintains/{id}")
  public XfR putUpdate(@RequestBody TaxCodeMaintain taxCodeMaintain,@PathVariable Long id) {
      taxCodeMaintain.setId(id);
      return XfR.ok(taxCodeMaintainServiceImpl.updateById(taxCodeMaintain));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param taxCodeMaintain ${table.comment}
   * @return XfR
   */
  @PatchMapping("/taxcodemaintains/{id}")
  public XfR patchUpdate(@RequestBody TaxCodeMaintain taxCodeMaintain,@PathVariable Long id) {
      TaxCodeMaintain uptaxCodeMaintain = taxCodeMaintainServiceImpl.getById(id);
      if(uptaxCodeMaintain != null){
        uptaxCodeMaintain = ObjectCopyUtils.copyProperties(taxCodeMaintain,uptaxCodeMaintain,true);
      }
      return XfR.ok(taxCodeMaintainServiceImpl.updateById(uptaxCodeMaintain));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/taxcodemaintains/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(taxCodeMaintainServiceImpl.removeById(id));
  }

  @PostMapping("/taxcodemaintains/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "tax_code_maintain");
     params.put("request", condition);

     return XfR.ok(taxCodeMaintainServiceImpl.querys(params));
  }

}
