package com.xforceplus.dajiang.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.dajiang.entity.TaxCodeRule;
import com.xforceplus.dajiang.service.ITaxCodeRuleService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-08-16
 */
@RestController
public class TaxCodeRuleController {

  @Autowired
  private ITaxCodeRuleService taxCodeRuleServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param taxCodeRule ${table.comment}
   * @return
   */
  @GetMapping("/taxcoderules" )
  public XfR getTaxCodeRules(XfPage page, TaxCodeRule taxCodeRule) {
    return XfR.ok(taxCodeRuleServiceImpl.page(page, Wrappers.query(taxCodeRule)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/taxcoderules/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(taxCodeRuleServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param taxCodeRule ${table.comment}
   * @return XfR
   */
  @PostMapping("/taxcoderules")
  public XfR save(@RequestBody TaxCodeRule taxCodeRule) {
     return XfR.ok(taxCodeRuleServiceImpl.save(taxCodeRule));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param taxCodeRule ${table.comment}
   * @return XfR
   */
  @PutMapping("/taxcoderules/{id}")
  public XfR putUpdate(@RequestBody TaxCodeRule taxCodeRule,@PathVariable Long id) {
      taxCodeRule.setId(id);
      return XfR.ok(taxCodeRuleServiceImpl.updateById(taxCodeRule));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param taxCodeRule ${table.comment}
   * @return XfR
   */
  @PatchMapping("/taxcoderules/{id}")
  public XfR patchUpdate(@RequestBody TaxCodeRule taxCodeRule,@PathVariable Long id) {
      TaxCodeRule uptaxCodeRule = taxCodeRuleServiceImpl.getById(id);
      if(uptaxCodeRule != null){
        uptaxCodeRule = ObjectCopyUtils.copyProperties(taxCodeRule,uptaxCodeRule,true);
      }
      return XfR.ok(taxCodeRuleServiceImpl.updateById(uptaxCodeRule));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/taxcoderules/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(taxCodeRuleServiceImpl.removeById(id));
  }

  @PostMapping("/taxcoderules/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "tax_code_rule");
     params.put("request", condition);

     return XfR.ok(taxCodeRuleServiceImpl.querys(params));
  }

}
