package com.xforceplus.delivery.cloud.gen.logistics.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

/**
 * <p>
 * 
 * </p>
 *
 * @author Hanyongjie
 * @since 2021-01-13
 */
@Setter
@Getter
@TableName("logistics_details")
@ApiModel(value = "LogisticsDetailsEntity对象", description = "")
public class LogisticsDetailsEntity implements Serializable{

private static final long serialVersionUID=1L;

        @TableId(value = "id", type = IdType.AUTO)
        private Long id;

    @ApiModelProperty(value = "主表ID")
    private Long mainId;

    @ApiModelProperty(value = "物品ID")
    private String goodsCode;

    @ApiModelProperty(value = "物品名称")
    private String goodsName;

    @ApiModelProperty(value = "物品来源：1-销项业务单，2-开票，3-退票，4-物流退件,5-补发件")
    private String goodsOrig;

    @ApiModelProperty(value = "物品类型：1-封面，2-发票，3-附件，4-销货清单 5-业务单")
    private String goodsType;

    @ApiModelProperty(value = "物品影像url")
    private String goodsUrl;

    @ApiModelProperty(value = "发票代码")
    private String invoiceCode;

    @ApiModelProperty(value = "发票号码")
    private String invoiceNo;

    @ApiModelProperty(value = "发票联次:0-空，1-抵扣联，2-发票联 3-两联均有")
    private String invoiceSheet;

    @ApiModelProperty(value = "发票类型： 增值税专用发票-s，增值税普通发票-c，增值税电子普通发票-ce")
    private String invoiceType;

    @ApiModelProperty(value = "开票日期")
    private String paperDrewDate;

    @ApiModelProperty(value = "收件备注")
    private String receiverRemark;

    @ApiModelProperty(value = "备注")
    private String remark;


        }
