package com.xforceplus.delivery.cloud.gen.logistics.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

/**
 * <p>
 * 
 * </p>
 *
 * @author Hanyongjie
 * @since 2021-01-13
 */
@Setter
@Getter
@TableName("logistics_main")
@ApiModel(value = "LogisticsMainEntity对象", description = "")
public class LogisticsMainEntity implements Serializable{

private static final long serialVersionUID=1L;

        @TableId(value = "id", type = IdType.AUTO)
        private Integer id;

    @ApiModelProperty(value = "业务物流状态1-待寄送，2-无需寄送，3-寄送中，4-异常，5-已签收")
    private String businessLgtStatus;

    @ApiModelProperty(value = "业务签收人")
    private String businessSignName;

    @ApiModelProperty(value = "业务物流签收时间")
    private LocalDateTime businessSignTime;

    @ApiModelProperty(value = "月结卡号")
    private String custCard;

    @ApiModelProperty(value = "目的地代码")
    private String destinationCode;

    @ApiModelProperty(value = "快递公司编码")
    private String expressCode;

    @ApiModelProperty(value = "快递公司名称")
    private String expressName;

    @ApiModelProperty(value = "快递公司物流签收时间")
    private LocalDateTime expressSignTime;

    @ApiModelProperty(value = "选择的快递类型:1-在线下单，2-自己联系物流  3-自送")
    private String expressType;

    @ApiModelProperty(value = "订单号")
    private String orderNo;

    @ApiModelProperty(value = "包裹状态：1-正常 9-取消")
    private String parcelStatus;

    @ApiModelProperty(value = "付款方式:1-寄方付，2-收方付，3-第三方付")
    private String payMethod;

    @ApiModelProperty(value = "收件方详细地址")
    private String receiverAddr;

    @ApiModelProperty(value = "收件方公司名称")
    private String receiverCompanyName;

    @ApiModelProperty(value = "收件方名称")
    private String receiverName;

    @ApiModelProperty(value = "收件方电话")
    private String receiverTel;

    @ApiModelProperty(value = "寄件方地址")
    private String senderAddr;

    @ApiModelProperty(value = "寄件方公司名称")
    private String senderCompanyName;

    @ApiModelProperty(value = "寄件方名称")
    private String senderName;

    @ApiModelProperty(value = "寄件方电话")
    private String senderTel;

    private LocalDateTime senderTime;

    @ApiModelProperty(value = "运单号")
    private String waybillNo;

    @ApiModelProperty(value = "备注")
    private String remark;

    private LocalDateTime createTime;

    private LocalDateTime updateTime;

    @ApiModelProperty(value = "推送时间")
    private LocalDateTime pushDate;

    @ApiModelProperty(value = "推送业务系统状态：-1-推送失败，0-待推送，1-推送成功")
    private Integer pushStatus;

    @ApiModelProperty(value = "推送结果")
    private String pushResult;


        }
