package com.xforceplus.delivery.cloud.tax.api.common;

import com.xforceplus.core.common.domain.JsonResult;
import com.xforceplus.delivery.cloud.common.api.GlobalResult;
import com.xforceplus.delivery.cloud.common.api.ViewResult;

/**
 * @vlog: 高于生活，源于生活
 * @Desc: TODO
 * @Author: Hanyongjie
 * @CreateDate: 2020-07-02 10:03
 * @Version: 1.0
 */
public final class ApiResult {

	public static ViewResult toViewResult(JsonResult jsonResult) {
		if (jsonResult == null) {
			return ViewResult.failed();
		}
		if (jsonResult.isSuccess()) {
			return ViewResult.success(jsonResult.getData(),jsonResult.getMessage());
		}
		return ViewResult.failed(jsonResult.getMessage());
	}

	public static JsonResult toJsonResult(GlobalResult viewResult) {
		if (viewResult == null) {
			return JsonResult.error();
		}
		if (viewResult.isOk()) {
			return JsonResult.ok(viewResult.getMessage());
		}
		return JsonResult.error(viewResult.getMessage());
	}

}
