package com.xforceplus.delivery.cloud.tax.api.configuration;

import com.xforceplus.delivery.cloud.common.component.MdcAsyncExecutor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.util.concurrent.Executor;

/**
 * @vlog: 高于生活，源于生活
 * @Desc: TODO
 * @Author: Hanyongjie
 * @CreateDate: 2020-07-03 00:07
 * @Version: 1.0
 */
@Slf4j
@Configuration
public class JanusAsyncExecutorConfiguration {

    /**
     * @Description: MDC线程池 需配置log.pattern
     * @Param: []
     * @Return: java.util.concurrent.Executor
     * @Author: duqing@xforceplus.com
     * @Date: 2018-12-03 21:17
     */
    @Bean("mdcAsync")
    public Executor xJanusAsyncExecutor() {
        return new MdcAsyncExecutor("xJanus-");
    }

}