package com.xforceplus.delivery.cloud.tax.api.constants;

import lombok.Getter;

import java.util.StringJoiner;

public final class AopOperationEnum {

    /**
     * 执行唯一标识
     */
    public interface InvokeIdentifier {
        String GLOBAL_FEEDBACK = "GLOBAL_FEEDBACK";
        String GLOBAL_DISPATCH = "GLOBAL_DISPATCH";
        String GLOBAL_RECEIVE = "GLOBAL_RECEIVE";
        String GLOBAL_UPLOAD = "GLOBAL_UPLOAD";
        String JANUS_HTTP = "JANUS_HTTP";
        String JANUS_HTTP_GET = "JANUS_HTTP_GET";
        String JANUS_HTTP_POST = "JANUS_HTTP_POST";
    }

    /**
     * 对应的数据字典类型为BUSINESS_OPERATION_TYPE
     */
    public interface BusinessTypeCode {
        String BILL_TODO = "BILL_TODO";//上传单据待办
        String BILL_STATUS = "BILL_STATUS";//同步单据状态
        String BILL_DATA = "BILL_DATA";//同步单证数据
        String IMAGE_URL_UPDATE = "IMAGE_URL_UPDATE";//更新影像地址
        String INVOICE_AUTH_RESULT = "INVOICE_AUTH_RESULT";//认证结果回写
        String INVOICE_AUTH_REQUEST = "INVOICE_AUTH_REQUEST";//认证请求
        String INVOICE_INVOICE_ABANDON = "INVOICE_INVOICE_ABANDON";//发票作废
        String INVOICE_INVOICE_REDFLUSH = "INVOICE_INVOICE_REDFLUSH";//发票红冲
        String INVOICE_OPERATION_TYPE = "INVOICE_OPERATION_TYPE";//发票红冲

        String SELLER_SALESBILL_UPLOAD = "SELLER_SALESBILL_UPLOAD";//业务单上传
        String SELLER_SALESBILL_ABANDON = "SELLER_SALESBILL_ABANDON";//业务单作废
        String SELLER_SALESBILL_BILLPUSHV4 = "SELLER_SALESBILL_BILLPUSHV4";//业务单反馈

        String PURCHASER_INVOICEMNGT_PUSHV4 = "PURCHASER_INVOICEMNGT_PUSHV4";//进项协同下发
        String INVOICE_TURN_OUT = "INVOICE_TURN_OUT";//进项税转出
        String IMAGE_URL_DETAIL = "IMAGE_URL_DETAIL";//影像调阅详情
        String IMAGE_DETAIL_INFO = "IMAGE_DETAIL_INFO";//影像详细查询
        String ALL_BILL_SSO_URL = "ALL_BILL_SSO_URL";//全量单据池单点url
        String MDM_SUPPLIER_INFO = "MDM_SUPPLIER_INFO";//MDM推送客商信息
        String BUSINESS_STATUS = "BUSINESS_STATUS";//通用的业务状态变更
    }

    /**
     * 对应的数据字典类型为OP_RECORD_OPERATION_TYPE
     */
    @Getter
    public enum OperateType {
        /**
         * 上行UPLOAD
         **/
        RECEIVE(10, "业务系统请求"),
        UPLOAD1(21, "上传操作1"),
        UPLOAD2(22, "上传操作2"),
        UPLOAD3(23, "上传操作3"),
        UPLOAD(30, "上传平台(属地)"),
        JANUS_HTTP(33, "发送请求到平台"),
        JANUS_HTTP_GET(35, "发送请求到平台(GET)"),
        JANUS_HTTP_POST(37, "发送请求到平台(POST)"),
        /**
         * 仅持久化操作
         */
        PERSIST(40, "持久化"),
        /**
         * 下行分发
         **/
        FEEDBACK(50, "平台反馈(属地)"),
        DISPATCH1(61, "分发操作1"),
        DISPATCH2(62, "分发操作2"),
        DISPATCH3(63, "分发操作3"),
        DISPATCH(70, "分发业务系统");

        int type;
        String desc;

        OperateType(int type, String desc) {
            this.type = type;
            this.desc = desc;
        }

        @Override
        public String toString() {
            return new StringJoiner("-", "", "").add("" + type).add(desc).toString();
        }

    }

    @Getter
    public enum OperateState {

        INITIAL(0, "初始"), SUCCESS(200, "成功"), FAILURE(500, "失败");

        int state;
        String desc;

        OperateState(int state, String desc) {
            this.state = state;
            this.desc = desc;
        }

        @Override
        public String toString() {
            return new StringJoiner("-", "", "").add("" + state).add(desc).toString();
        }

    }

}
