package com.xforceplus.delivery.cloud.tax.api.constants;

/**
 * @vlog: 高于生活，源于生活
 * @Desc: 单据类型
 * @Author: Hanyongjie
 * @CreateDate: 2020-07-12 01:04
 * @Version: 1.0
 */

import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.ToString;

@Getter
@ToString
@AllArgsConstructor
public enum BillTypeEnum {

    AR("AR", "应收"), AP("AP", "应付");

    private String code;
    private String name;

    public static String getName(String code) {
        for (BillTypeEnum item : BillTypeEnum.values()) {
            if (item.getCode() == code) {
                return item.name;
            }
        }
        return null;
    }

}