package com.xforceplus.delivery.cloud.tax.api.constants;

import lombok.Getter;

import java.util.StringJoiner;

public enum InvoiceTypeEnum {
    qs("qs", "全电增值税电子专用发票"),
    qc("qc", "全电增值税电子普通发票"),
    sz("sz", "全电增值税纸质专用发票"),
    cz("cz", "全电增值税纸质普通发票"),
    s("s", "增值税专用发票"),
    c("c", "增值税普通发票"),
    ce("ce", "增值税电子普通发票"),
    cb("cb", "增值税电子普通发票(区块链)"),
    ct("ct", "增值税电子普通发票(通行费)"),
    j("j", "机动车统一销售发票"),// 影像
    v("v", "机动车统一销售发票"),// 进项
    cj("cj", "增值税普通发票(卷票)"),// 影像
    ju("ju", "增值税普通发票(卷票)"),// 进项
    se("se", "增值税电子专用发票"),
    cd("cd", "浙江通用(电子)发票"),
    p("p", "航空运输电子客票行程单(飞机票)"),
    vs("vs", "二手车销售统一发票"),
    t("t", "火车票"),
    quota("quota", "定额发票"),
    taxi("taxi", "出租车票"),
    bus("bus", "公交车车票"),
    toll("toll", "过路费发票"),
    im("im", "通用机打发票"),
    fj("fj", "附件"),
    xhqd("xhqd", "销货清单"),
    yb("yb", "公路运输发票"),
    ys("ys", "水路运输发票"),
    a("a", "其他发票");

    @Getter
    private String type, desc;

    InvoiceTypeEnum(String type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", InvoiceTypeEnum.class.getSimpleName() + "[", "]")
                .add("type=" + type + "").add("desc=" + desc + "").toString();
    }

}
