package com.xforceplus.delivery.cloud.tax.api.controller;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.xforceplus.delivery.cloud.common.api.GlobalResult;
import com.xforceplus.delivery.cloud.common.api.PageResult;
import com.xforceplus.delivery.cloud.common.api.ViewResult;
import com.xforceplus.delivery.cloud.mybatis.ExampleWrapper;
import com.xforceplus.delivery.cloud.mybatis.PageQueryStringHandler;
import com.xforceplus.delivery.cloud.mybatis.ViewPage;
import com.xforceplus.delivery.cloud.tax.api.domain.BusinessOperateVO;
import com.xforceplus.delivery.cloud.tax.api.entity.BusinessOperate;
import com.xforceplus.delivery.cloud.tax.api.logging.AopOperationActuator;
import com.xforceplus.delivery.cloud.tax.api.service.IBusinessOperateService;
import com.xforceplus.delivery.cloud.webmvc.support.QueryString;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Collection;
import java.util.Map;

/**
 * <p>
 * 前端控制器
 * </p>
 *
 * @author Hanyongjie
 * @since 2020-09-03
 */
@RestController
@RequestMapping("/operation/")
@ApiOperation(value = "操作记录")
public class BusinessOperateController {

    @Autowired
    private AopOperationActuator aopOperationActuator;

    @Autowired
    private IBusinessOperateService iBusinessOperateService;

    @PostMapping("/pageList")
    @ApiOperation("分页查询操作记录")
    @PreAuthorize("hasAuthority('business:operation:list')")
    public PageResult<BusinessOperate> pageList(@RequestBody Map<String, String> params,
                                                @QueryString(handler = {PageQueryStringHandler.class}) Page<BusinessOperate> page) {
        return ViewPage.of(iBusinessOperateService.page(page, new ExampleWrapper<>(BusinessOperate.class, params)));
    }

    @PostMapping("/executeOperate")
    @ApiOperation("执行操作记录")
    @PreAuthorize("hasAuthority('business:operation:exec')")
    public GlobalResult executeOperate(@RequestBody BusinessOperate businessOperate) {
        return this.aopOperationActuator.executeOperate(businessOperate);
    }

    /***
     * 通过ID集合删除执行队列中的数据分发任务
     *
     * @param idList
     * @return
     */
    @PostMapping("/removeByIds")
    @ApiOperation("通过ID集合删除操作记录")
    @PreAuthorize("hasAuthority('business:operation:remove')")
    public GlobalResult removeByIds(@RequestBody Collection<String> idList) {
        return ViewResult.of(this.iBusinessOperateService.removeByIds(idList));
    }

    /**
     * 通过ID/业务类型/关键字等的组合删除(ID优先)
     *
     * @param businessOperateVO
     * @return
     */
    @PostMapping("/removeByExample")
    @ApiOperation("通过ID/服务/事件/关键字的组合删除(ID优先)")
    @PreAuthorize("hasAuthority('business:operation:remove')")
    public GlobalResult removeByExample(@RequestBody BusinessOperateVO businessOperateVO) {
        return this.iBusinessOperateService.removeByExample(businessOperateVO);
    }

}
