package com.xforceplus.delivery.cloud.tax.api.controller;

import com.xforceplus.core.common.domain.SealedRecMessage;
import com.xforceplus.delivery.cloud.common.api.GlobalResult;
import com.xforceplus.delivery.cloud.tax.api.janus.SealedRecMessagePublisher;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @vlog: 高于生活，源于生活
 * @Desc: 接受集成平台下发的消息
 * @Author: Hanyongjie
 * @CreateDate: 2020-07-11 20:31
 * @Version: 1.0
 */
@RestController
@RequestMapping("apollo")
@ApiOperation(value = "平台消息控制器")
public class SealedRecMessageController {

    @Autowired
    private SealedRecMessagePublisher sealedRecMessagePublisher;

    /**
     * 接受集成平台下发的消息
     *
     * @param sealedRecMessage
     * @return
     */
    @PostMapping(value = "/sealedRecMessage")
    @ApiOperation("处理集成平台下发的消息")
    @PreAuthorize("hasAuthority('apollo:sealedrecmessage:handle')")
    public GlobalResult handleSealedRecMessage(@RequestBody SealedRecMessage sealedRecMessage) {
        return this.sealedRecMessagePublisher.publishEvent(sealedRecMessage);
    }

}