package com.xforceplus.delivery.cloud.tax.api.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 *
 * </p>
 *
 * @author Hanyongjie
 * @since 2020-09-03
 */
@Setter
@Getter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "BusinessOperate对象", description = "")
public class BusinessOperate implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    @ApiModelProperty(value = "跟踪号")
    private String traceId;

    @ApiModelProperty(value = "关键字")
    private String keyword;

    @ApiModelProperty(value = "执行唯一标识")
    private String invokeIdentifier;

    @ApiModelProperty(value = "业务类型字典值")
    private String businessType;

    @TableField(exist = false)
    @ApiModelProperty(value = "业务类型字典码")
    private String businessTypeCode;

    @ApiModelProperty(value = "业务key")
    private String businessKey;

    @ApiModelProperty(value = "操作类型")
    private Integer operateType;

    @ApiModelProperty(value = "操作状态")
    private Integer operateState;

    @ApiModelProperty(value = "操作时间")
    private LocalDateTime operateTime;

    @ApiModelProperty(value = "操作备注")
    private String operateRemark;

    @ApiModelProperty(value = "调用参数")
    private String arguments;

    @ApiModelProperty(value = "返回值")
    private String returnValue;

    @ApiModelProperty(value = "异常堆栈")
    private String stackTrace;

    @Override
    public String toString() {
        return String.format("[%s]%s::%s", businessTypeCode, operateType, businessKey);
    }

}
