package com.xforceplus.delivery.cloud.tax.api.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 分发重试队列
 * </p>
 *
 * @author Hanyongjie
 * @since 2020-07-27
 */
@Setter
@Getter
@ApiModel(value = "DispatchRetryQueue对象", description = "分发重试队列")
public class DispatchRetryQueue implements Serializable {

    private static final long serialVersionUID = 1L;

    private Long id;

    @ApiModelProperty(value = "服务名")
    private String svc;

    @ApiModelProperty(value = "跟踪号")
    private String traceId;

    @ApiModelProperty(value = "事件名")
    private String evtname;

    @ApiModelProperty(value = "任务关键字")
    private String keyword;

    @ApiModelProperty(value = "执行参数")
    private String args;

    @ApiModelProperty(value = "执行次数")
    private Integer counter;

    @ApiModelProperty(value = "创建时间")
    private LocalDateTime createTime;

    @ApiModelProperty(value = "更新时间")
    private LocalDateTime updateTime;

    @Override
    public String toString() {
        return String.format("[%s,%s]%s", evtname, counter, keyword);
    }

}
