package com.xforceplus.delivery.cloud.tax.api.janus;

import com.xforceplus.apollo.config.refresh.ConfigRefreshThread;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.stereotype.Component;

/**
 * @vlog: 高于生活，源于生活
 * @Desc: 停止配置文件刷新线程
 * @Author: Hanyongjie
 * @CreateDate: 2020-06-21 15:48
 * @Version: 1.0
 */
@Component
public class JanusCoreConfigRefreshThread implements ApplicationRunner, ApplicationListener<ContextClosedEvent> {

    /**
     * Handle an application event.
     *
     * @param event the event to respond to
     */
    @Override
    public void onApplicationEvent(ContextClosedEvent event) {
        ConfigRefreshThread.getConfigRefreshThread().stop();
    }

    @Override
    public void run(ApplicationArguments args) throws Exception {
        ConfigRefreshThread.getConfigRefreshThread().stop();
    }

}