package com.xforceplus.delivery.cloud.tax.api.janus;

import com.xforceplus.core.common.domain.JsonResult;
import com.xforceplus.core.common.domain.SealedRecMessage;
import com.xforceplus.core.handle.IReceiveMsgServiceHandler;
import com.xforceplus.delivery.cloud.tax.api.common.ApiResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @vlog: 高于生活，源于生活
 * @Desc: TODO
 * @Author: Hanyongjie
 * @CreateDate: 2020-09-17 15:30
 * @Version: 1.0
 */
@Component
public class JanusCoreMsgHandler implements IReceiveMsgServiceHandler {

    @Autowired
    private SealedRecMessagePublisher sealedRecMessagePublisher;

    @Override
    public JsonResult process(SealedRecMessage sealedRecMessage) {
        return ApiResult.toJsonResult(this.sealedRecMessagePublisher.publishEvent(sealedRecMessage));
    }

}
