package com.xforceplus.delivery.cloud.tax.api.janus;

import com.xforceplus.core.common.domain.SealedRecMessage;
import com.xforceplus.delivery.cloud.common.util.BeanUtils;
import com.xforceplus.delivery.cloud.common.util.JsonUtils;
import lombok.Getter;
import lombok.Setter;


public class JanusCoreReceiveMsg<T> {

    @Getter
    private T payload;
    @Getter
    private HeaderOther headerOther;
    @Getter
    private SealedRecMessage sealedRecMessage;

    public JanusCoreReceiveMsg() {
    }

    public JanusCoreReceiveMsg(SealedRecMessage sealedRecMessage, Class<T> payloadClass) {
        this.sealedRecMessage = sealedRecMessage;
        this.headerOther = BeanUtils.mapToBean(sealedRecMessage.getHeader().getOthers(), HeaderOther.class);
        this.payload = JsonUtils.toBean(sealedRecMessage.getPayload().getObj(), payloadClass);
    }

    public static <T> JanusCoreReceiveMsg<T> of(SealedRecMessage sealedRecMessage, Class<T> payloadClass) {
        return new JanusCoreReceiveMsg<>(sealedRecMessage, payloadClass);
    }

    @Setter
    @Getter
    public static class HeaderOther {
        private String businessBillType;
        private String businessNo;
        private String clientAddress;
        private String code;
        private String customerNo;
        private String eventType;
        private String fourSqsQ;
        private String fourType;
        private String message;
        private String payLoadId;
        private String platformNo;
        private String sellerGroupId;
        private String sqsQueue;
        private String status;
        private String systemOrign;
        private String operationType;
    }

}